# Reproduction code for "Diffusion Models without Classifier-free Guidance"

### 1. Environment setup

```bash
conda create -n mg python=3.12 -y
conda activate mg
pip install -r requirements.txt
```

### 2. Training

We list the hyper-paremeters for the final SiT-XL/2 model in our paper as the defaults of `train.py`. Run the following command to train models

```bash
torchrun --nnodes=2 --nproc_per_node=8 train.py
```

### 3. Evaluation

We use the reference batch and the evaluator script provided by [ADM](https://github.com/openai/guided-diffusion/tree/main/evaluations). Run the following command to sample images

```bash
torchrun --nnodes=2 --nproc_per_node=8 test.py --ckpt-path path/to/ckpt
```
