# How to Run the Pipeline

This document explains how to run `pipeline_combined.sh` for a new protein target.  
Each run with `--array=1-10` will produce **100 final results** (10 jobs × 10 seeds each).

## General Usage

Submit the job to SLURM:
```bash
sbatch pipeline_combined.sh
````

Before running, update the script with the correct parameters for your protein.
In the script, set: BASE_DIR="saved/projected_diffusion_<protein_name>"

## Step 1: Initial Generation Update

```python
contigmap.contigs=[A1-82/0 5/0 B1-6]
inference.input_pdb=custom_data/PDZ_BetaSheetExt/2ejy.pdb
projection.peptide_path=custom_data/PDZ_BetaSheetExt/2ejy.pdb
+potentials.guiding_potentials='["type:custom_recenter_ROG,weight:20,rog_weight:15,distance:7,rc_x:0.77,rc_y:5.13,rc_z:-11.53"]'
````

## Step 2: Mapping Update

```python
--map "A:1-5->A:89-93; B:6-87->A:1-82; B:88-93->B:1-6"
````

## Step 3: Final Stage

```python
contigmap.contigs=[A1-82/6/A89-93/20-40/0 B1-6]
projection.peptide_path=custom_data/PDZ_BetaSheetExt/2ejy.pdb
+potentials.guiding_potentials='["type:custom_recenter_ROG,weight:20,rog_weight:15,distance:7,rc_x:0.77,rc_y:5.13,rc_z:-11.53"]'
````
