#!/bin/bash
#SBATCH --time=2:00:00
#SBATCH --gres=gpu:1
#SBATCH --partition=gpu-mig
#SBATCH -J "seed_sweep"
#SBATCH --array=1-100
#SBATCH --output=logs_protein/seed_%A_%a.out

cd ~/research/Projected-RFdiffusion
module purge
module load miniforge/24.3.0-py3.11
module load cudnn/8.9.4.25
source activate rfdiff

SAMPLES_PER_JOB=10

START=${SLURM_ARRAY_TASK_ID:-1}
START=$((START - 1))

OUTDIR="saved/reference_2aww_center"
mkdir -p "${OUTDIR}"

for SAMPLE_IDX in $(seq 0 $((SAMPLES_PER_JOB-1))); do
    SEED=$((START * SAMPLES_PER_JOB * 200 + SAMPLE_IDX * 200))
    OUTPREFIX="${OUTDIR}/design_${SEED}"

    echo ">>> Running seed=${SEED} (job=${SLURM_ARRAY_TASK_ID}, sample=${SAMPLE_IDX})"

    python scripts_adapt/run_inference.py \
      contigmap.contigs="[B1-90/60-100/0, C1-4]" \
      inference.input_pdb="custom_data/final_contig/2aww_1_1_0.pdb" \
      inference.output_prefix="${OUTPREFIX}" \
      inference.seed="${SEED}" \
      inference.num_designs=1 \
      +potentials.guiding_potentials='["type:custom_recenter_ROG,weight:20,rog_weight:15,distance:7,rc_x:-10.72,rc_y:1.96,rc_z:-6.41"]'
done
