import numpy as np
import scipy
from scipy.sparse.csgraph import minimum_spanning_tree
from scipy.sparse import coo_matrix
from collections import Counter

def create_problem(seed, N):
    np.random.seed(seed)
    dim = 2
    cities = np.random.random((N, dim))
    distance_matrix = scipy.spatial.distance.cdist(cities, cities)

    return cities, distance_matrix

def optimize_D(Din, lr, n_iter = 100):
    D = np.copy(Din)
    best_cnt = float('inf')
    best_D = np.copy(Din)

    for i in range(n_iter):
        mst = minimum_spanning_tree(D)
        mst_coo = coo_matrix(mst)
        m = np.mean(mst_coo.data)

        c = Counter()

        for i in range(D.shape[0] - 1):
            c[mst_coo.row[i]] += 1
            c[mst_coo.col[i]] += 1

        np.fill_diagonal(D, 0)

        cnt_deg_more_2 = len(list(filter(lambda x : x > 2, [x for x in c.values()])))

        #print(np.mean(mst_coo.data), np.max([x for x in c.values()]), cnt_deg_more_2)

        if cnt_deg_more_2 < best_cnt:
            best_cnt = cnt_deg_more_2
            best_D = np.copy(D)

            print('best', best_cnt)

        for v, degree in c.items():
            D[:, v] += lr * m * (degree - 2)
            D[v, :] += lr * m * (degree - 2)

    return best_D
