The code for **PEER pressure: Model-to-Model Regularization for Single Source Domain Generalization**.

### Before Use (Important!)
- Before you use the notebooks/training scripts(${data}_base.sh/${data}_rand.sh), please take it out from their folders to the same directory as the README.md file.

### 1. Dependencies

- All environment is saved in environment.yml, we recommend that users create a virtual environment with the yml file for use of the code.
- The source code is adjusted for use in python 3.9

### 2. Datasets

- Download the dataset from the anonymous [Google drive](https://drive.google.com/drive/folders/1PvpuX5okdriwr-edGMy02VnKQM2qNNcq?usp=sharing).
- Place the dataset files under the path `./data/`.

### 3. Model Weights

#### Model weights for AlexNet
- WARNING. this model weight is not finetuned on the source domain of PACS. Hence it requires the pretraining process.
- Download the AlexNet model weights (alexnet_caffe.pth.tar) from the anonymous [Google drive](https://drive.google.com/drive/folders/1Y4m2_NDPS5Eft8GldbdNHSg3rpoxFCEE?usp=sharing).
- Place the model weight under the path `./network/pretrained/`.
- Before running the code, adjust Line 84 of the ./network/alex_net.py to match your path.

### 4. Pretrain

- Before pretraining, please move the script files from `./scripts/` to the same directory as the README.md file.
- First, run the command `sh {$data}_base.sh 0 0`. The command will pretrain the model. Please check if the script file is using correct hyperparams. 

### 5. Train

- Before training, please move the script files from `./scripts/` to the same directory as the README.md file.
- Run the command `sh {$data}_rand.sh 0 0`. to train the sDG model using PEER. Please check if the script file is using correct hyperparams.
- FYI: sh {script-file-name}.sh a b; a= gpu_id, b= run_id. In our experiments for PEER, a single GPU is sufficient.


### 5.5 All in One Script

- Or, you can run the command `sh {$data}_all.sh 0 0`. to pretrain and train the sDG model using PEER. Please check if the script file is using correct hyperparams.
- FYI: sh {script-file-name}.sh a b; a= gpu_id, b= run_id. In our experiments for PEER, a single GPU is sufficient.


### 6. Experiments

#### Notebooks
- Before you use it, please take it out from the ./notebooks folder

#### Digits Experiment
- Digit Experiment: MNIST -> MNIST,MNIST-M,USPS,SVHN,SYNDIGIT
- Available Models: custom (Convolutional Network for Digits)

#### PACS Experiment 
- PACS Experiment: P -> A,C,S
- Available Models: alexnet, resnet-18/50

#### Office-Home Experiment
- Office-Home Experiment: Real-World -> Art, Clipart, Product
- Available Models: resnet-18/50

#### VLCS Experiment
- VLCS Experiment: V -> L,C,S
- Available Models: resnet-18/50

### Reference
- Our code is built using the source code of PDEN (https://github.com/lileicv/PDEN). We thank the authors of PDEN. We record references in the top of each file. Furthermore, we reference codes from (https://github.com/AntixK/PyTorch-Model-Compare) and (https://github.com/themrzmaster/git-re-basin-pytorch). We thank the authors for sharing their work for the machine learning community! 
