
# $1 gpuid
# $2 runid

# 1. Pretrain
data=mnist
backbone=custom
pretrained=False
projection_dim=128
epochs=100

lr=1e-4
lr_scheduler=none #none/cosine
optimizer=adam #adam/sgd
# Base Model Path
svroot=saved-model/${data}/base_${backbone}_${pretrained}_${projection_dim}_run${2} 

python3 main_base.py --gpu $1 --data ${data} --epochs ${epochs} --nbatch 100 --lr ${lr} --svroot $svroot --backbone ${backbone} --pretrained ${pretrained} --projection_dim ${projection_dim} --lr_scheduler ${lr_scheduler} --optimizer ${optimizer}
python3 main_test.py --gpu $1 --modelpath $svroot/best.pkl --svpath $svroot/test.log --backbone ${backbone} --projection_dim ${projection_dim} --data ${data}


# 2. Train
w_oracle=2.0

n_tgt=200
max_tgt=199
tgt_epochs=10
lmda=0.0051 #lmda for L_peer
gen=cnn
interpolation=img

data=mnist
backbone=custom
pretrained=False # Do not Touch
projection_dim=128
loss_fn=bt #bt/infonce/mdar

batchsize=128
autoaug=None

oracle=True
oracle_type=self_digits

# Model Load/Save Path
svroot=saved-model/${data}/${gen}_${interpolation}_${backbone}_${loss_fn}_${pretrained}_${projection_dim}_lmda${lmda}_oracle${oracle}_${oracle_type}_${w_oracle}_run${2}
baseroot=saved-model/${data}/base_${backbone}_${pretrained}_${projection_dim}_run0/best.pkl

CUDA_VISIBLE_DEVICES=$1 python3 main_rand.py --gpu $1 --data ${data} --gen $gen --backbone ${backbone} --loss_fn ${loss_fn} --projection_dim ${projection_dim} --interpolation $interpolation --n_tgt ${n_tgt} --tgt_epochs ${tgt_epochs} --nbatch 100 --batchsize ${batchsize} --lr 1e-4 --w_oracle $w_oracle --ckpt ${baseroot} --svroot ${svroot} --pretrained ${pretrained} --oracle ${oracle} --lmda ${lmda} --oracle_type ${oracle_type} --autoaug ${autoaug}
python3 main_test.py --gpu $1 --modelpath ${svroot}/${max_tgt}-best.pkl --svpath ${svroot}/test.log --backbone ${backbone} --projection_dim ${projection_dim} --data ${data}
