
# $1 gpuid
# $2 runid

# 1. Pretrain
data=officehome
backbone=resnet18 #resnet18/resnet50 
pretrained=True
projection_dim=1024
epochs=100
batchsize=64

lr=1e-4
lr_scheduler=none #none/cosine/step
optimizer=adam #adam/sgd
# Base Model Path
svroot=saved-model/${data}/base_${backbone}_${pretrained}_${projection_dim}_run${2} 

python3 main_base.py --gpu $1 --data ${data} --epochs ${epochs} --nbatch 100 --lr ${lr} --batchsize ${batchsize} --svroot $svroot --backbone ${backbone} --pretrained ${pretrained} --projection_dim ${projection_dim} --lr_scheduler ${lr_scheduler} --optimizer ${optimizer}
python3 main_test.py --gpu $1 --modelpath $svroot/best.pkl --svpath $svroot/test.log --backbone ${backbone} --projection_dim ${projection_dim} --data ${data}


# 2. Train

w_oracle=2.0

n_tgt=20 
max_tgt=19
tgt_epochs=10
lmda=0.0051

gen=cnn
interpolation=img
oracle=True
oracle_type=self_office

data=officehome
backbone=resnet18 #resnet18/resnet50
pretrained=True
projection_dim=1024
loss_fn=bt #bt/infonce/mdar
lr=1e-4
lr_scheduler=none
optimizer=adam #sgd/adam

batchsize=64

autoaug=None

# Model Load/Save Path
svroot=saved-model/${data}/${gen}_${interpolation}_${backbone}_${loss_fn}_${pretrained}_${projection_dim}_lmda${lmda}_oracle${oracle}_${oracle_type}_${w_oracle}_lr${lr}_${lr_scheduler}_${optimizer}_run${2}
baseroot=saved-model/${data}/base_${backbone}_${pretrained}_${projection_dim}_run0/best.pkl

CUDA_VISIBLE_DEVICES=$1 python3 main_rand.py --gpu $1 --data ${data} --gen $gen --backbone ${backbone} --loss_fn ${loss_fn} --projection_dim ${projection_dim} --interpolation $interpolation --n_tgt ${n_tgt} --tgt_epochs ${tgt_epochs} --nbatch 200 --batchsize ${batchsize} --lr ${lr} --w_oracle $w_oracle --ckpt ${baseroot} --svroot ${svroot} --pretrained ${pretrained} --oracle ${oracle} --lmda ${lmda} --lr_scheduler ${lr_scheduler} --optimizer ${optimizer} --oracle_type ${oracle_type} --autoaug ${autoaug}
python3 main_test.py --gpu $1 --modelpath ${svroot}/${max_tgt}-best.pkl --svpath ${svroot}/test.log --backbone ${backbone} --projection_dim ${projection_dim} --data ${data}
