
# $1 gpuid
# $2 runid

w_oracle=2.0

n_tgt=100 #30 
max_tgt=99 #29
tgt_epochs=10 #5
lmda=0.0051

gen=cnn
interpolation=img

oracle=True
oracle_type=self_pacs

data=pacs 
backbone=alexnet #alexnet/resnet18/resnet50
pretrained=True
projection_dim=1024
loss_fn=bt #bt/infonce/mdar
lr=1e-4 
lr_scheduler=none #cosine/step 
optimizer=adam #sgd/adam

batchsize=128

autoaug=None

# Model Load/Save Path
svroot=saved-model/${data}/${gen}_${interpolation}_${backbone}_${loss_fn}_${pretrained}_${projection_dim}_lmda${lmda}_oracle${oracle}_${oracle_type}_${w_oracle}_lr${lr}_${lr_scheduler}_${optimizer}_run${2}
baseroot=saved-model/${data}/base_${backbone}_${pretrained}_${projection_dim}_run0/best.pkl

# step1
CUDA_VISIBLE_DEVICES=$1 python3 main_rand.py --gpu $1 --data ${data} --gen $gen --backbone ${backbone} --loss_fn ${loss_fn} --projection_dim ${projection_dim} --interpolation $interpolation --n_tgt ${n_tgt} --tgt_epochs ${tgt_epochs} --nbatch 100 --batchsize ${batchsize} --lr ${lr} --w_oracle $w_oracle --ckpt ${baseroot} --svroot ${svroot} --pretrained ${pretrained} --oracle ${oracle} --lmda ${lmda} --lr_scheduler ${lr_scheduler} --optimizer ${optimizer} --oracle_type ${oracle_type} --autoaug ${autoaug}
python3 main_test.py --gpu $1 --modelpath ${svroot}/${max_tgt}-best.pkl --svpath ${svroot}/test.log --backbone ${backbone} --projection_dim ${projection_dim} --data ${data}

#done
