import argparse
import os

from cli.lkh_postprocess_batch import main as run_lkh_postprocess_batch
from cli.lkh_preprocess import main as run_lkh_preprocess


def main(args: argparse.Namespace) -> None:
    # problem generate
    path_to_lkh = "../LKH-3.0.10"
    path_to_src = "../mm_cvrp"

    args_dict = {
        "input": args.input,
        "n_agent": args.n_agent,
        "num_instance": args.num_instance,
        "timelimit": args.timelimit,
        "output": f"{path_to_lkh}/{args.output_folder}",
    }
    tmp_args = argparse.Namespace(**args_dict)
    run_lkh_preprocess(tmp_args)

    output = f"{args.output_folder}_{args.timelimit}s"
    # solve
    os.chdir(path_to_lkh)
    phrase = args.input.split("/")[-2] + "_" + os.path.basename(args.input)
    for i in range(args.num_instance):
        filename = f"{output}/{phrase}_{i}.par"
        print(filename)
        os.system(f"./LKH {filename}")

    # summarize
    os.chdir(path_to_src)
    # FIXME : location
    args_dict = {
        "input_folder": f"{path_to_lkh}/{output}",
        "output": f"{path_to_lkh}/{output}",
        "n_node": args.n_node,
    }
    tmp_args = argparse.Namespace(**args_dict)
    run_lkh_postprocess_batch(tmp_args)


if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    parser.add_argument("-i", "--input", type=str, required=True, help="input")
    parser.add_argument("-a", "--n-agent", type=int, required=True, help="num agent")
    parser.add_argument("-n", "--num-instance", type=int, required=True, help="num instance")
    parser.add_argument("--n-node", type=int, required=True, help="num instance")
    parser.add_argument("-t", "--timelimit", type=int, default=-1, help="num instance")
    parser.add_argument("--output-folder", type=str, default="LKH_problem_exp", help="output-folder")

    args = parser.parse_args()
    main(args)
