import pickle
import sys
import time

import osmnx as ox


def main(place_name):
    # 指定する都市の名前で地図データを取得（東京の場合）
    begin = time.time()

    # 道路ネットワークを取得する（ドライブ可能な道路に限定）
    graph = ox.graph_from_place(place_name, network_type="drive")

    # グラフの統計情報を表示
    basic_stats = ox.basic_stats(graph)
    # print(basic_stats)

    end = time.time()

    # print(end - begin)

    output_folder = "map_raw"
    nodes, edges = ox.graph_to_gdfs(graph)  # グラフをGeoDataFrameに変換
    num_node = len(nodes)

    # 取得したグラフをプロット
    fig, ax = ox.plot_graph(
        graph,
        figsize=(10, 10),
        node_size=5,
        edge_linewidth=1,
        save=True,
        filepath=f"{output_folder}/{place_name}_{num_node}.png",
    )

    # ノードの座標（緯度・経度）を取得

    # Pickleファイルとして保存
    with open(f"{output_folder}/{place_name}_{num_node}.pickle", "wb") as f:
        pickle.dump(nodes, f)

    # Parquetから読み込む
    nodes.to_parquet(f"{output_folder}/{place_name}_{num_node}.parquet")
    # print(nodes.shape)


if __name__ == "__main__":
    main(sys.argv[1])
