import argparse
import multiprocessing
import os

from cli.lkh_postprocess_batch import main as run_lkh_postprocess_batch
from cli.lkh_preprocess import main as run_lkh_preprocess
from cli.plot_proposed_method import main as plot_proposed_method


def execute(filename_list):
    for filename in filename_list:
        os.system(f"./LKH {filename}")


def split_list(a, m):
    avg_len = len(a) // m
    remainder = len(a) % m

    result = []
    start = 0

    for i in range(m):
        # 基本の長さに、余りがある限り1を足す
        end = start + avg_len + (1 if i < remainder else 0)
        result.append(a[start:end])
        start = end

    return result


def main(args: argparse.Namespace) -> None:
    # problem generate
    path_to_lkh = "../LKH-3.0.10"
    path_to_src = "../mm_cvrp"

    args_dict = {
        "gpu": args.gpu,
        "n_agent": args.n_agent,
        "n_node": args.n_node,
        "n_instance": args.num_instance,
        "test_data": args.input,
        "pretrained_path": args.pretrained_path,
        "naive": False,
        "ignore_ot": False,
        "add_local_search": False,
        "output_folder": f"{path_to_lkh}/{args.output_folder}_original",
        "use_output4lkh": True,
        "lkh_output_folder": f"{path_to_lkh}/{args.output_folder}",
        "timelimit": args.timelimit,
    }
    tmp_args = argparse.Namespace(**args_dict)
    plot_proposed_method(tmp_args)

    args_dict = {
        "input": args.input,
        "n_agent": args.n_agent,
        "num_instance": args.num_instance,
        "timelimit": args.timelimit,
        "output": f"{path_to_lkh}/{args.output_folder}",
    }
    tmp_args = argparse.Namespace(**args_dict)
    run_lkh_preprocess(tmp_args)

    output = f"{args.output_folder}_{args.timelimit}s"
    breakpoint()
    solutionfile_base = (
        f"{args.pretrained_path.replace('/', ':', -1)}_{args.input.replace('/', ':', -1)}_ignoreOTFalse"
    )
    # solve
    os.chdir(path_to_lkh)

    phrase = args.input.split("/")[-2] + "_" + os.path.basename(args.input)
    filepath_list = [f"{output}/{solutionfile_base}_{str(i).zfill(3)}.par" for i in range(args.num_instance)]
    n = args.num_instance
    m = args.num_process
    filepath_chunk_list = split_list(filepath_list, m)

    # queue = multiprocessing.Queue()
    processes = [multiprocessing.Process(target=execute, args=(filepath_chunk_list[i],)) for i in range(m)]
    for p in processes:
        p.start()
    for p in processes:
        p.join()

    # phrase = args.input.split("/")[-2] + "_" + os.path.basename(args.input)
    # for i in range(args.num_instance):
    #     filename = f"{output}/{solutionfile_base}_{str(i).zfill(3)}.par"
    #     print(filename)
    #     os.system(f"./LKH {filename}")

    # summarize
    os.chdir(path_to_src)
    # FIXME : location
    args_dict = {
        "input_folder": f"{path_to_lkh}/{output}",
        "output": f"{path_to_lkh}/{output}",
        "n_node": args.n_node,
        "location": args.input.split("/")[1].split(",")[0],
        "num_instance": args.num_instance,
        "keyword": args.pretrained_path.replace("/", ":", -1),
    }
    tmp_args = argparse.Namespace(**args_dict)
    run_lkh_postprocess_batch(tmp_args)


if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    parser.add_argument("--gpu", type=int, default=0, help="number of agents")
    parser.add_argument("-i", "--input", type=str, required=True, help="input")
    parser.add_argument("-a", "--n-agent", type=int, required=True, help="num agent")
    parser.add_argument("-n", "--num-instance", type=int, required=True, help="num instance")
    parser.add_argument("--n-node", type=int, required=True, help="num instance")
    parser.add_argument("-t", "--timelimit", type=int, default=-1, help="num instance")
    parser.add_argument("--output-folder", type=str, default="LKH_problem_exp", help="output-folder")
    parser.add_argument("--pretrained-path", type=str, help="path to network")
    parser.add_argument("--num-process", type=int, default=1, help="num instance")

    args = parser.parse_args()
    main(args)
