import subprocess


def get_git_commit_hash():
    try:
        # Gitコマンドを実行して現在のコミットハッシュを取得
        commit_hash = subprocess.check_output(["git", "rev-parse", "HEAD"]).strip().decode("utf-8")
        return commit_hash
    except subprocess.CalledProcessError:
        return "Could not retrieve commit hash"


def check_no_uncommitted_changes():
    try:
        # Gitコマンドを実行して変更がないかを確認
        status_output = subprocess.check_output(["git", "status", "--porcelain"]).strip().decode("utf-8")
        unstaged_changes = []

        for line in status_output.split("\n"):
            # Changes not staged for commit のセクションに該当する行を抽出
            if (
                line.startswith("M")
                or line.startswith("D")
                or line.startswith("A")
                or line.startswith("R")
                or line.startswith("C")
            ):
                unstaged_changes.append(line)

        return unstaged_changes
    except subprocess.CalledProcessError:
        return ["Could not retrieve Git status."]
