# LongBench Inference

This script (`pred.py`) performs inference on the LongBench dataset using various pretrained language models.

---

## Directory Structure

```
LongBench/
├── pred.py                              # Inference script
├── modeling_littrans.py                 # Model-specific implementations
├── llama_flash_attn_monkey_patch.py     # Flash Attention patch for Llama
├── config/
│   ├── dataset2maxlen.json              # Max generation lengths per dataset
│   ├── dataset2prompt.json              # Prompt formats per dataset
│   ├── model2maxlen.json                # Max input lengths per model
│   └── model2path.json                  # Paths to pretrained models
├── pred/                                # Prediction outputs
├── pred_e/                              # Prediction outputs for LongBench-E
└── quota_razor_rank.out                 # Config file for specific inference methods
```

---

## Usage

### Run Inference

To execute inference:

```bash
python pred.py --model <model_name> [--e] [--method <method_name>]
```

- `--model`: Choose a model from the supported list (e.g., `llama3-8b`).
- `--e`: Evaluate using the LongBench-E subset.
- `--method`: Specify an optional inference method (`quota`, `razor`, etc.).

### Example:

```bash
python pred.py --model llama3-8b --method littrans
```

Ensure pretrained model checkpoints and configuration files (`model2path.json`, etc.) are correctly placed under the `config/` directory.

---

# QwQ Inference

Similar with LongBench Inference.

