## Setup

Install Requirements:

```bash
$ pip install -r requirements.txt
```

Find out location of `site-packages` folder for your environment using the following command:

```bash
$ python -m site
```

When using `miniconda`, it typically looks like `$HOME/miniconda3/envs/default1/lib/python3.10/site-packages`.

Copy the files in the `human_eval` directory to `$HOME/miniconda3/envs/default/lib/python3.10/site-packages/human_eval/`.

Create API keys with hosted providers as necessary and replace the `base_url` and `API_KEY` placeholders.

## Execution

Training Sample Script

```bash
#!/bin/bash
task="mmlu"
dataset="cais/mmlu"
model="qwen3_8b" 
model_name="Qwen/Qwen3-8B"
for i in {2..5}; do
  echo "Running training with $i experts..."
  mkdir -p checkpoints/$model/$i/
  CUDA_VISIBLE_DEVICES=0 python multi_slm_collab_new.py \
          --mode train \
          --model_name $model_name \
          --num_experts $i \
          --task $task --dataset $dataset \
          --strategy refinement_chain --refine_with full \
          --epochs 5 --logfile logs/train_${task}_${model}_${i}.log \
          --output_dir "checkpoints/${model}/${i}/" 
done
```

Inference Sample Script

```bash
#!/bin/bash
task="mmlu"
dataset="cais/mmlu"
model="qwen3_8b" 
model_name="Qwen/Qwen3-8B"
for i in {2..5}; do
  echo "Running inference with $i experts..."
  mkdir -p checkpoints/$model/$i/
  CUDA_VISIBLE_DEVICES=0 python multi_slm_collab_new.py \
          --mode inference \
          --model_name $model_name \
          --num_experts $i \
          --task $task --dataset $dataset \
          --checkpoint "checkpoints/${model}/${i}/collaboration_controller_${task}_final_*.pt" \
          --strategy refinement_chain --refine_with full \
          --epochs 5 --logfile logs/infer_${task}_${model}_${i}.log \
          --output_dir "checkpoints/${model}/${i}/" 
done
```
