
import skimage.io
import PIL.Image 
from PIL import Image
import cv2
import numpy as np
save_dir = 'path of dynamics train dataset'
base_dir = 'path of dynamics train dataset'
video = []
segs = []
max_instance = 10
bboxes = []
flows = []
    
    
for i in range(60):
    rgba_image = PIL.Image.open(f'{base_dir}/{str(i).zfill(3)}.png')
    rgb_image = rgba_image.convert('RGB')
    rgb_image = rgb_image.resize((256,256),Image.BICUBIC)
    video.append(np.array(rgb_image))
    
    seg = PIL.Image.open(f'{base_dir}/segmentation_{str(i).zfill(5)}.png')
    seg = seg.resize((256,256),Image.NEAREST)
    seg = np.array(seg)
    segs.append(seg)
    
    flow = np.zeros([seg.shape[0],seg.shape[1],3])
    flows.append(flow)
    
    bbox = np.zeros([max_instance,4])
    for j in range(1,max_instance):
        x,y = np.where(seg == j)
        if x.shape[0]>0:
            bbox[j-1] = np.array([x.min(),y.min(),x.max(),y.max()])
    bboxes.append(bbox)
video = np.array(video)
video = video.astype(np.float64) / 255.
np.save(f'{save_dir}/video.npy',video)
segs = np.array(segs).astype(np.int32)
np.save(f'{save_dir}/segmentation.npy',segs)

bboxes = np.array(bboxes) / 256
np.save(f'{save_dir}/bboxes.npy',bboxes)

flows = np.array(flows)
np.save(f'{save_dir}/flows.npy',flows)

