### Renyi Supervised Contrastive Learning for Transferable Representation


#### Run

1. RenyiSCL on ImageNet
'''
python main_rscl_mc.py \
--dist-url 'tcp://localhost:10002' \
--multiprocessing-distributed \
--world-size 1 \
--rank 0 \
--data /data/ImageNet/ \
--n_cls 1000 \
-b 1024 \
--optimizer lars \
--lr 0.8 \
--warmup-epochs 5 \
--epochs 200 \
--gamma 2.0 \
--temp 0.2 \
--alpha 0.001 \
--outdir ../exps/ \
--buffer 65536 \
--trial rscl_200ep \
--ra_s 1.0 \
--ra_t 1.0 \
--re_s 0.0 \
--re_t 0.0 \
--crop-min 0.08 \
--n_crops 6
'''

2. SupCon on ImageNet
'''
python main_rscl_mc.py \
--dist-url 'tcp://localhost:10002' \
--multiprocessing-distributed \
--world-size 1 \
--rank 0 \
--data /data/ImageNet/ \
--n_cls 1000 \
-b 1024 \
--optimizer lars \
--lr 0.8 \
--warmup-epochs 5 \
--epochs 200 \
--gamma 1 \
--temp 0.2 \
--alpha 0.001 \
--outdir ../exps/ \
--buffer 65536 \
--trial scl_200ep \
--ra_s 1.0 \
--ra_t 1.0 \
--re_s 0.0 \
--re_t 0.0 \
--crop-min 0.08 \
--n_crops 6
'''

3. SLMLP on ImageNet
'''
python main_slmlp.py \
--dist-url 'tcp://localhost:10002' \
--multiprocessing-distributed \
--world-size 1 \
--rank 0 \
--data ../ImageNet/ \
--n_cls 1000 \
--coarse_type down_up \
-b 1024 \
--optimizer lars \
--lr 0.4 \
--warmup-epochs 5 \
--epochs 100 \
--temp 0.2 \
--outdir ../exps/ \
--trial slmlp \
--ra_s 1.0 \
--ra_t 1.0 \
--re_s 0.0 \
--re_t 0.0 \
--crop-min 0.08
'''

#### Coarse-to-fine transfer learning on ImageNet

'''
python main_rscl.py \
--dist-url 'tcp://localhost:10002' \
--multiprocessing-distributed \
--world-size 1 \
--rank 0 \
--data /data/ImageNet/ \
--n_cls 486, 753 or 918 \
-b 1024 \
--optimizer lars \
--lr 0.8 \
--warmup-epochs 5 \
--epochs 200 \
--gamma 2.0 \
--temp 0.2 \
--alpha 0.001 \
--outdir ../exps/ \
--buffer 65536 \
--trial rscl_200ep \
--ra_s 1.0 \
--ra_t 1.0 \
--re_s 0.0 \
--re_t 0.0 \
--crop-min 0.08 \
--n_crops 6
'''

