### Usage

#### CIFAR-100-LT
To reproduce our results,
```
PORT=$[$RANDOM + 10000]

python renyiscl_cifar.py \
  --dataset cifar100 \
  --arch resnet32 \
  --data [PATH TO CIFAR] \
  --imb-factor 0.01 \
  --alpha 0.01 \
  --wd 5e-4 \
  --mark [EXP NAME] \
  --lr 0.05 \
  --moco-t 0.1 \
  --moco-k 1024 \
  --moco-dim 32 \
  --feat_dim 64 \
  --aug cifar100 \
  --dist-url "tcp://localhost:$PORT" \
  --epochs 400 \
  --obj rcpc \
  --gamma_renyi 1.5
```

#### ImageNet-LT
To reproduce our results,
```
PORT=$[$RANDOM + 10000]

python renyiscl_lt.py \
  --dataset imagenet \
  --arch resnext50_32x4d \
  --data [PATH TO IMAGENET] \
  --alpha 0.05 \
  --wd 5e-4 \
  --mark [EXP NAME] \
  --lr 0.02 \
  --moco-t 0.2 \
  --aug randclsstack_sim \
  --randaug_m 10 \
  --randaug_n 2 \
  --dist-url "tcp://localhost:$PORT" \
  --epochs 400 \
  --obj rcpc \
  --gamma_schedule region \
  --gamma_many 1.5 \
  --gamma_medium 1.5 \
  --gamma_few 1.0
```

#### iNaturalist
To reproduce our results,
```
PORT=$[$RANDOM + 10000]

python renyiscl_lt.py \
  --dataset inat \
  --arch resnet50 \
  --data [PATH TO INATURALIST] \
  --alpha 0.05 \
  --wd 1e-4 \
  --mark [EXP NAME] \
  --lr 0.02 \
  --moco-t 0.2 \
  --aug randcls_sim \
  --randaug_m 10 \
  --randaug_n 2 \
  --dist-url "tcp://localhost:$PORT" \
  --epochs 400 \
  --num_classes 8142 \
  --obj rcpc \
  --gamma_renyi 1.1
```

Result is logged at `./data/{dataset}/{mark}/{mark}.log`