import pandas as pd
import ast

df = pd.read_csv('/data/wmdp_50_samples.csv')

df['choices'] = df['choices'].apply(lambda x: ', '.join(ast.literal_eval(x)))
df['Question'] = df['input'] + '\n Candidates: ' + df['choices']
df = df.rename(columns={'target': 'Affirmative Response'})
df_final = df[['Question', 'Affirmative Response']]
df_final.to_csv('/data/wmdp/embedding_attack/embeedding_attack_bio50_samples.csv', index=False)