conda create --name rl-s4-env python=3.8
conda activate rl-s4-env

conda install pytorch pytorch-cuda=11.7 -c pytorch -c nvidia
pip install atari-py
pip install pyprind
pip install absl-py
pip install gin-config
pip install gym==0.23.0
pip install tqdm
pip install blosc
pip install git+https://github.com/google/dopamine.git
pip install einops
pip install opt_einsum
pip install pykeops==2.0
pip install pytorch-fast-transformers
pip install omegaconf==2.1.1
pip install transformers==4.5.1
pip install wandb==0.12.10
pip install cmake
pip install memory_profiler

pip install dm_control==1.0.2
pip install git+https://github.com/aravindr93/mjrl.git
git clone https://github.com/rail-berkeley/d4rl.git
cd d4rl
cp ../reinforcementlearn-ds4/gym/alt_d4rl_setup.py setup.py
pip install -e .
cd ..

#### Mujoco Get

mkdir $HOME/.mujoco
wget https://github.com/deepmind/mujoco/releases/download/2.1.1/mujoco-2.1.1-linux-x86_64.tar.gz -O mujoco1.tar.gz
tar -xf mujoco1.tar.gz -C $HOME/.mujoco
rm mujoco1.tar.gz

wget https://mujoco.org/download/mujoco210-linux-x86_64.tar.gz -O mujoco0.tar.gz
tar -xf mujoco0.tar.gz -C $HOME/.mujoco
rm mujoco0.tar.gz

sudo apt-get install libpcap-dev libpq-dev
sudo apt-get install -y \
    libgl1-mesa-dev \
    libgl1-mesa-glx \
    libglew-dev \
    libosmesa6-dev \
    software-properties-common
sudo apt-get install -y patchelf

echo "export LD_LIBRARY_PATH=\$LD_LIBRARY_PATH:/usr/lib/nvidia" >> $HOME/.bashrc
echo "export LD_LIBRARY_PATH=\$LD_LIBRARY_PATH:$HOME/.mujoco/mujoco210/bin" >> $HOME/.bashrc
export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$HOME/.mujoco/mujoco210/bin
export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:/usr/lib/nvidia

#### Dataset download

mkdir data_mujoco
cd data_mujoco
python ../reinforcementlearn-ds4/gym/data/download_d4rl_datasets.py --type 2 &> ds_get.log
cd ..

