## Introduction
MM-RCR is a multimodal reaction condition recommendation model that jointly learns from the SMILES representations, reaction graphs, and textual corpus. To train MM-RCR, we construct 1.2 million pair-wised Q\&A instruction datasets. Our experimental results demonstrate that MM-RCR achieves state-of-the-art performance on two open benchmark datasets and exhibits strong generalization capabilities on out-of-domain (OOD) datasets. MM-RCR has the potential to accelerate high-throughput condition screening in chemical synthesis.

<p align="center">
<img src="./figures/framework-update.png" height = "360" alt="" align=center />
</p>

## Installation Guide
Create a virtual environment to run the code of MM-RCR.<br>
```
cd MM-RCR
conda create -n MM-RCR_env python=3.8
conda activate MM-RCR_env
pip install -r requirements.txt
```

## Quick Demos
1. Place the datasets under `./dataset`
2. Train the model. We provide experiment scripts under the folder `./scripts`. For instance, you can train the model with text and SMILES representations by:
```bash
bash ./scripts/train.sh 
```
3. Evaluate the model.
```bash
bash ./scripts/test.sh 
```