#!/usr/bin/env bash

# Check if a virtual environment exists
if [[ ! -d .venv ]]; then
    echo 'Make sure a virtual environment is set up!' >& 2
    exit 1
fi

# Activate the virtual environment
source .venv/bin/activate

# Check if `sbx-rl` is installed
if ! python3 -m pip list | grep 'sbx-rl' &> /dev/null; then
    echo 'Make sure `sbx-rl` is installed!' >& 2
    exit 1
fi

# Get the Python version used in the virtual environment
version=$(python3 --version | cut -d ' ' -f 2 | cut -d '.' -f -2)

# Apply the patch
git apply --directory=".venv/lib/python$version/site-packages/" tools/sbx.patch

exit $?
