## Prerequisite Installation

The code has been tested with Python3.6, pytorch-lightning 1.1.6 and Cuda 10.2:
```
conda create --name corrnet3d python=3.6
conda activate corrnet3d
pip install pytorch-lightning==1.1.6
pip install --upgrade https://github.com/unlimblue/KNN_CUDA/releases/download/0.2/KNN_CUDA-0.2-py3-none-any.whl
pip install "git+git://github.com/erikwijmans/Pointnet2_PyTorch.git#egg=pointnet2_ops&subdirectory=pointnet2_ops_lib"
conda install torchvision torchaudio cudatoolkit=10.2 -c pytorch
pip install h5py
pip install tables
pip install matplotlib
pip install tqdm
pip install torch-scatter torch-sparse torch-cluster torch-spline-conv torch-geometric -f https://data.pyg.org/whl/torch-1.9.0+cu102.html
```

## Datasets
Download train.h5 and test.h5 from https://github.com/ZENGYIMING-EAMON/CorrNet3D

## FPS sampling
```
python sampling.py
```

## Train & Test
To train
```
uncomment 'cli_main_test_()' main.py
python main.py --gpus=3 --batch_size=<batch_size> --data_dir=<train_data_PATH:./trainset_fps64.h5> --test_data_dir=<test_data_PATH:./testset.h5> --max_epoch 30 --enc_emb_dim 128
```
To test
```
uncomment 'cli_main()' in main.py
python main.py --gpus=3 --batch_size=1 --data_dir=<train_data_PATH:./trainset_fps64.h5> --test_data_dir=<test_data_PATH:./testset.h5> --enc_emb_dim 128 --ckpt_user <ckpt_PATH> 

```
