#!/bin/bash


epochs=1500 # Note: we need 1.5 times more iterations for N=100.


for dist in UU; do

    function test () {
      train_options=$1
      echo python3 print_exp_dir.py ${train_options}

      model_path=`python3 print_exp_dir.py ${train_options}`

      echo ${model_path}
      for test_N in 100; do
        test_dat="./datasets/test/${dist}_size-$(printf "%02d" ${test_N})_test.dat"
        echo python3 test.py ${model_path}/$(printf "%05d" ${epochs})_net.pth ${test_dat}

        python3 test.py ${model_path}/$(printf "%05d" ${epochs})_net.pth ${test_dat}

      done
    }

    # test the models that accepts variable-size input.

    train_N=100
    
    ## WeaveNet-80f
    train_options="--network_type WeaveNet -L 80 -lr 0.0001 -w 64 -W 64 -N ${train_N} ${train_N} -d ${dist} -e ${epochs} --pin_memory --non_blocking --num_workers=2 --cudnn_benchmark --validation 100 -lf 0.01 -cp 100 --start_epoch 400"
    echo python3 train.py ${train_options}

    python3 train.py ${train_options}

    test "${train_options}"
    
    ## WeaveNet-80b
    train_options="--network_type WeaveNet -L 80 -lr 0.0001 -w 64 -W 64 -N ${train_N} ${train_N} -d ${dist} -e ${epochs} --pin_memory --non_blocking --num_workers=2 --cudnn_benchmark --validation 100 -lb 0.01 -cp 100"
    echo python3 train.py ${train_options}

    python3 train.py ${train_options}

    test "${train_options}"

done
