
#=========== CIFAR10 =================================================
sample_dir="./experiments/edm-cifar10-32x32-cond-vp_IIA_M_3_steps_6/"
# Generate 50000 images and save them as sample_dir/*/*.png
python generate.py --steps 6 --sampling_method IIA  --M 3 --outdir=$sample_dir --seeds=0-49999 --subdirs \
    --network=./pretrained/advanced/edm-cifar10-32x32-cond-vp.pkl
# Calculate FID
python fid.py calc --images=$sample_dir \
    --ref=https://nvlabs-fi-cdn.nvidia.com/edm/fid-refs/cifar10-32x32.npz 

#=========== FFHQ =================================================
#sample_dir="./experiments/edm-ffhq-64x64-uncond-vp_IIA2_M_3_steps_6/"
#Generate 50000 images and save them as sample_dir/*/*.png
#python generate.py --steps 6 --sampling_method IIA2 --M 3 --outdir=$sample_dir --seeds=0-49999 --subdirs \
#    --network=./pretrained/advanced/edm-ffhq-64x64-uncond-vp.pkl
# Calculate FID
#python fid.py calc --images=$sample_dir \
#    --ref=https://nvlabs-fi-cdn.nvidia.com/edm/fid-refs/ffhq-64x64.npz 

#=========== AFHQV2 =================================================
#sample_dir="./experiments/edm-avhqv2-64x64-uncond-vp_IIA2_M_3_steps_6/"
# Generate 50000 images and save them as sample_dir/*/*.png
#python generate.py --steps 6 --sampling_method IIA --M 3 --outdir=$sample_dir --seeds=0-49999 --subdirs \
#    --network=./pretrained/advanced/edm-afhqv2-64x64-uncond-vp.pkl
#python fid.py calc --images=$sample_dir \
#    --ref=https://nvlabs-fi-cdn.nvidia.com/edm/fid-refs/afhqv2-64x64.npz 

#=========== Imagenet64 =================================================
#sample_dir="./experiments/edm-imagenet-64x64-cond-adm_IIA_M_3_steps_6/"
# Generate 50000 images and save them as sample_dir/*/*.png
#python generate.py --steps 6 --sampling_method IIA --M 3 --outdir=$sample_dir --seeds=0-49999 --subdirs \
#    --network=./pretrained/advanced/edm-imagenet-64x64-cond-adm.pkl
# Calculate FID
#python fid.py calc --images=$sample_dir \
#    --ref=https://nvlabs-fi-cdn.nvidia.com/edm/fid-refs/imagenet-64x64.npz 
