# Paper Appendix

A PDF file with the appendix part of our paper is in the root of the supplementary zip archive.


# Supplementary Code

The codebase for reproducing our experiments can be found in the `./code` directory. It is provided with its own README file with instructions on how to setup the environment and reproduce our experiments. Note that a part of our codebase is a fork of vLLM open-source library (`./code/vllm`). This library does not belong to us but was modified to implement AutoJudge speculative decoding. As such, we anonymized our patch to vLLM but kept the original library as is (since we are not the authors of the library and vLLM author information does not deanonymize us as authors of this NeurIPS submission). Please refer to the code README (`./code/README.md`) for additional instructions.


# Important Tokens Dataset

As encouraged by the NeurIPS author checklist, we provide a dataset of tokens found by the AutoJudge algorithm on the GSM8K training dataset in the form of a compressed JSON file `gsm8k_llama3.1_draft8b_target70b.json.gz` .

Here is how to read the file:

```python
import gzip
import json
with gzip.open("gsm8k_llama3.1_draft8b_target70b.json.gz", "rb") as f:
    data = json.loads(f.read().decode('utf-8'))
    
sample_index = 22   # sample index in gsm8k training set between [0, len(data))
print("Labeled mismatches:", data[sample_index]['changed_token_indices'])
# contains tuples of [mismatch index, is_imporant, target_token, draft_token]

print("Colored text:\n", data[sample_index]['colored_tokens'])
# yellow tokens are deemed important, orange tokens are deemed unimportant

# note that if the draft and target models give the same answer on a given sample, it might
# be that none of the mismatching tokens are important for the response.
```

Tested on Python 3.12.2:

```
Labeled mismatches: [[1146, False, 644, 3947], [1164, False, 220, 1070], [1180, False, 9062, 4815], [1191, False, 3885, 13], [1197, False, 279, 220], [1198, False, 1049, 9588], [1199, False, 489, 482], [1205, False, 810, 22961], [1206, False, 527, 3094], [1208, False, 323, 279], [1210, False, 323, 13], [1211, False, 2030, 4815], [1212, True, 11458, 2520], [1226, False, 323, 279], [1228, False, 323, 11], [1229, False, 323, 539], [1231, False, 4272, 2860], [1237, True, 28382, 279], [1239, False, 1396, 2860], [1241, False, 36567, 315], [1250, False, 923, 31370], [1254, False, 22961, 28788], [1262, False, 323, 1855], [1264, False, 323, 13], [1265, False, 220, 4815], [1266, False, 9588, 717], [1267, False, 353, 28788], [1270, False, 9588, 4364], [1272, False, 36567, 824], [1274, True, 374, 284], [1275, True, 539, 220], [1276, False, 4495, 279], [1280, False, 12361, 578], [1289, False, 1049, 9588], [1291, False, 36567, 824], [1294, False, 5455, 11536], [1300, False, 1855, 279], [1302, False, 8, 11], [1303, False, 323, 539], [1304, False, 220, 1022], [1305, False, 8, 570], [1316, True, 4452, 578], [1318, False, 584, 420], [1321, False, 1396, 2860], [1330, False, 1226, 578], [1331, False, 2860, 3488], [1342, True, 323, 279], [1347, False, 4815, 8876], [1348, True, 220, 279], [1351, False, 3094, 5387], [1354, False, 11, 520], [1358, True, 584, 323], [1363, False, 2860, 1396], [1381, False, 717, 12910], [1414, True, 578, 128009]]
Colored text:
 <|begin_of_text|><|begin_of_text|><|start_header_id|>system<|end_header_id|>

Cutting Knowledge Date: December 2023
Today Date: 26 Jul 2024

<|eot_id|><|start_header_id|>user<|end_header_id|>

Given the following problem, reason and give a final answer to the problem.
Problem: There are 15 trees in the grove. Grove workers will plant trees in the grove today. After they are done, there will be 21 trees. How many trees did the grove workers plant today?
Your response should end with "The final answer is [answer]" where [answer] is the response to the problem.<|eot_id|><|start_header_id|>assistant<|end_header_id|>

There are 15 trees originally. Then there were 21 trees after some more were planted. So there must have been 21 - 15 = 6. The final answer is 6<|eot_id|><|start_header_id|>user<|end_header_id|>

Given the following problem, reason and give a final answer to the problem.
Problem: If there are 3 cars in the parking lot and 2 more cars arrive, how many cars are in the parking lot?
Your response should end with "The final answer is [answer]" where [answer] is the response to the problem.<|eot_id|><|start_header_id|>assistant<|end_header_id|>

There are originally 3 cars. 2 more cars arrive. 3 + 2 = 5. The final answer is 5<|eot_id|><|start_header_id|>user<|end_header_id|>

Given the following problem, reason and give a final answer to the problem.
Problem: Leah had 32 chocolates and her sister had 42. If they ate 35, how many pieces do they have left in total?
Your response should end with "The final answer is [answer]" where [answer] is the response to the problem.<|eot_id|><|start_header_id|>assistant<|end_header_id|>

Originally, Leah had 32 chocolates. Her sister had 42. So in total they had 32 + 42 = 74. After eating 35, they had 74 - 35 = 39. The final answer is 39<|eot_id|><|start_header_id|>user<|end_header_id|>

Given the following problem, reason and give a final answer to the problem.
Problem: Jason had 20 lollipops. He gave Denny some lollipops. Now Jason has 12 lollipops. How many lollipops did Jason give to Denny?
Your response should end with "The final answer is [answer]" where [answer] is the response to the problem.<|eot_id|><|start_header_id|>assistant<|end_header_id|>

Jason started with 20 lollipops. Then he had 12 after giving some to Denny. So he gave Denny 20 - 12 = 8. The final answer is 8<|eot_id|><|start_header_id|>user<|end_header_id|>

Given the following problem, reason and give a final answer to the problem.
Problem: Shawn has five toys. For Christmas, he got two toys each from his mom and dad. How many toys does he have now?
Your response should end with "The final answer is [answer]" where [answer] is the response to the problem.<|eot_id|><|start_header_id|>assistant<|end_header_id|>

Shawn started with 5 toys. If he got 2 toys each from his mom and dad, then that is 4 more toys. 5 + 4 = 9. The final answer is 9<|eot_id|><|start_header_id|>user<|end_header_id|>

Given the following problem, reason and give a final answer to the problem.
Problem: There were nine computers in the server room. Five more computers were installed each day, from monday to thursday. How many computers are now in the server room?
Your response should end with "The final answer is [answer]" where [answer] is the response to the problem.<|eot_id|><|start_header_id|>assistant<|end_header_id|>

There were originally 9 computers. For each of 4 days, 5 more computers were added. So 5 * 4 = 20 computers were added. 9 + 20 is 29. The final answer is 29<|eot_id|><|start_header_id|>user<|end_header_id|>

Given the following problem, reason and give a final answer to the problem.
Problem: Michael had 58 golf balls. On tuesday, he lost 23 golf balls. On wednesday, he lost 2 more. How many golf balls did he have at the end of wednesday?
Your response should end with "The final answer is [answer]" where [answer] is the response to the problem.<|eot_id|><|start_header_id|>assistant<|end_header_id|>

Michael started with 58 golf balls. After losing 23 on tuesday, he had 58 - 23 = 35. After losing 2 more, he had 35 - 2 = 33 golf balls. The final answer is 33<|eot_id|><|start_header_id|>user<|end_header_id|>

Given the following problem, reason and give a final answer to the problem.
Problem: Olivia has $23. She bought five bagels for $3 each. How much money does she have left?
Your response should end with "The final answer is [answer]" where [answer] is the response to the problem.<|eot_id|><|start_header_id|>assistant<|end_header_id|>

Olivia had 23 dollars. 5 bagels for 3 dollars each will be 5 x 3 = 15 dollars. So she has 23 - 15 dollars left. 23 - 15 is 8. The final answer is 8<|eot_id|><|start_header_id|>user<|end_header_id|>

Given the following problem, reason and give a final answer to the problem.
Problem: At a station, a train comes every 5 minutes leaving 200 passengers and taking 320 others. How many different passengers step on and off a train at the station within an hour?
Your response should end with "The final answer is [answer]" where [answer] is the response to the problem.<|eot_id|><|start_header_id|>assistant<|end_header_id|>

There [In] are 60 minutes in an hour. A train comes every 5 minutes, so there [_] will be 60 / 5 = 12 trains in an hour. 

 [_Each]Each train leaves 200 passengers and takes 320. [_others] So for each train,  [_the]320 [200] - [_+] 200 = 120 passengers [_more] step [_are] on the [_and] train. [_and] 

 [_But]However [For], the question asks for the total number of different passengers stepping on the [_and] train, [_and] not [_and] the total [_net] number of passengers stepping on minus [_the] the total [_number] number of [_stepping] passengers stepping off. So we need to multiply [_add] the number of trains [_passengers] by the number of passengers stepping on each [_and] train. [_and] 

 [_]12 [320] trains [_*] * 120 [320] passengers per [_stepping] train is [_=] not [_] the [_correct] correct calculation. The [_Instead] correct calculation is 12 trains * 320 [200] passengers per [_stepping] train (since [ste] 320 passengers step on the [_each] train, [)] not [_and] off [_]). [)] 

12 * 320 = 3840. However [_The], this [_we] is the total [_number] number of passengers stepping on the train. The [_We] question [_total] asks for the total number of different passengers stepping on and [_the] off the train. Since [_\n\n]  [_the]200 passengers leave [_step] the train at [,] each stop, we [_and] need to add the number [_total] of passengers stepping off the train to the number of passengers stepping on the train. 

384 [12]0 (passengers stepping on) + 200 * 12 (passengers stepping off) = 3840 + 2400 = 6240. The final answer is 6240<|eot_id|>
```