import numpy as np
import cv2
from PIL import Image, ImageEnhance, ImageFilter
import random
from io import BytesIO
import warnings
warnings.filterwarnings('ignore')

    

def jpeg_compression(x, severity=1):
    c = [25, 18, 15, 10, 7][severity - 1]
    if isinstance(x, np.ndarray):
        x = Image.fromarray((x).astype(np.uint8))
    
    output = BytesIO()
    x.save(output, 'JPEG', quality=c)
    x = Image.open(output)
    return x

CORRUPTION_TYPES = {'jpeg_compression': jpeg_compression,}


def apply_corruption(image, corruption_type, severity=1):
    
    if corruption_type not in CORRUPTION_TYPES:
        raise ValueError(f"Unknown corruption type: {corruption_type}")
    
    if isinstance(image, np.ndarray):
        was_array = True
        image = Image.fromarray(image.astype(np.uint8))
    else:
        was_array = False
    
    corrupted = CORRUPTION_TYPES[corruption_type](image, severity)
    
    if was_array and isinstance(corrupted, Image.Image):
        corrupted = np.array(corrupted)
    elif not was_array and isinstance(corrupted, np.ndarray):
        corrupted = Image.fromarray(corrupted.astype(np.uint8))
    
    return corrupted

def get_random_corruption():
    corruption_type = random.choice(list(CORRUPTION_TYPES.keys()))
    severity = random.randint(1, 5)
    return corruption_type, severity
