from typing import List
from XAgent.agent.base_agent import BaseAgent
from XAgent.utils import RequiredAbilities
from XAgent.message_history import Message

class ReflectAgent(BaseAgent):
    """This ReflectAgent class extends the BaseAgent class. It primarily has the ability of reflection 
    which means it can reflect upon the chat or dialogue and generate responses based on the messages
    received.

    Attributes:
        abilities (set): Required abilities for the agent, namely reflection in this case. 
    """

    abilities = set([RequiredAbilities.reflection])

    def parse(
        self,
        placeholders: dict = {},
        arguments:dict = None,
        functions=None,
        function_call=None,
        stop=None,
        additional_messages: List[Message] = [],
        *args,
        **kwargs
    ):
        """
        The function is used to parse various arguments and call the generate function with these parsed arguments.

        Args:
            placeholders (dict, optional): Placeholders for the agent's responses. 
            arguments(dict, optional): Argument to influence the response of the agent.
            functions (functions, optional): Functions to guide the agent's response.
            function_call (FunctionType, optional): Function called to generate agent's response. 
            stop (bool, optional): Flag to stop the induction of the response. 
            additional_messages (list, optional): Additional messages to be included in the response. 

        Returns:
            object: Response generated by the agent. 

        """
        prompt_messages = self.fill_in_placeholders(placeholders)
        messages = prompt_messages + additional_messages

        return self.generate(
            messages=messages,
            arguments=arguments,
            functions=functions,
            function_call=function_call,
            stop=stop,
            *args,**kwargs
        )