library(tidyverse)
library(readr)
library(ggplot2)
library(tidyr)
if (!dir.exists("accuracy")) {
  dir.create("accuracy")
}
results_20_50_3_3<- read_csv("results_with_D=20,p=50,q=3,K=3.csv")
selected_20_50_3_3_accuracy <- c("best_SEM_accuracy", "best_SEMK_accuracy", "best_SKM_accuracy","best_accuracy")
df_long_20_50_3_3_accuracy <- results_20_50_3_3 %>%
  select(selected_20_50_3_3_accuracy) %>%
  pivot_longer(
    everything(),
    names_to = "Variable",
    values_to = "Value"
  )
df_long_20_50_3_3_accuracy$Variable <- factor(
  df_long_20_50_3_3_accuracy$Variable,
  levels = c("best_accuracy", "best_SEM_accuracy", "best_SEMK_accuracy", "best_SKM_accuracy")
)
plot_accuracy_20_50_3_3<-ggplot(df_long_20_50_3_3_accuracy, aes(x = Variable, y = Value)) +
  geom_boxplot(fill = "skyblue", alpha = 0.7) +
  labs(title = "D=20,p=50,q=3,K=3",
       x="Classification accuracy",
       y = "") +
  theme_minimal()+
  theme(
    plot.title = element_text(size = 40, face = "bold", hjust = 0.5),
    axis.title.x = element_text(size = 30),
    axis.title.y = element_text(size = 30),
    axis.text.x = element_text(size = 15),
    axis.text.y = element_text(size = 15),     
    axis.line = element_line(color = "black"),
    panel.border = element_rect(color = "black", fill = NA)
  )+
  scale_x_discrete(labels = c("GSAKM", "SEM", "SEMK", "SKM"))
ggsave("accuracy/Plot_accuracy_20_50_3_3.png",plot=plot_accuracy_20_50_3_3)
stats_table_accuracy_20_50_3_3 <- results_20_50_3_3 %>%
  select(all_of(selected_20_50_3_3_accuracy)) %>%
  pivot_longer(
    everything(),
    names_to = "Variable",
    values_to = "Value"
  ) %>%
  group_by(Variable) %>%
  summarise(
    `Mean` = mean(Value, na.rm = TRUE),
    `SD` = sd(Value, na.rm = TRUE),
    .groups = "drop"
  )
write_csv(stats_table_accuracy_20_50_3_3, "accuracy/stats_table_accuracy_20_50_3_3.csv")


results_20_50_2_3<- read_csv("results_with_D=20,p=50,q=2,K=3.csv")
selected_20_50_2_3_accuracy <- c("best_SEM_accuracy", "best_SEMK_accuracy", "best_SKM_accuracy","best_accuracy")
df_long_20_50_2_3_accuracy <- results_20_50_2_3 %>%
  select(selected_20_50_2_3_accuracy) %>%
  pivot_longer(
    everything(),
    names_to = "Variable",
    values_to = "Value"
  )
df_long_20_50_2_3_accuracy$Variable <- factor(
  df_long_20_50_2_3_accuracy$Variable,
  levels = c("best_accuracy", "best_SEM_accuracy", "best_SEMK_accuracy", "best_SKM_accuracy")
)
plot_accuracy_20_50_2_3<-ggplot(df_long_20_50_2_3_accuracy, aes(x = Variable, y = Value)) +
  geom_boxplot(fill = "skyblue", alpha = 0.7) +
  labs(title = "D=20,p=50,q=2,K=3",
       x="Classification accuracy",
       y = "") +
  theme_minimal()+
  theme(
    plot.title = element_text(size = 40, face = "bold", hjust = 0.5),
    axis.title.x = element_text(size = 30),
    axis.title.y = element_text(size = 30),
    axis.text.x = element_text(size = 15),
    axis.text.y = element_text(size = 15), 
    axis.line = element_line(color = "black"),
    panel.border = element_rect(color = "black", fill = NA)
  )+
  scale_x_discrete(labels = c("GSAKM", "SEM", "SEMK", "SKM"))
ggsave("accuracy/Plot_accuracy_20_50_2_3.png",plot=plot_accuracy_20_50_2_3)
stats_table_accuracy_20_50_2_3 <- results_20_50_2_3 %>%
  select(all_of(selected_20_50_2_3_accuracy)) %>%
  pivot_longer(
    everything(),
    names_to = "Variable",
    values_to = "Value"
  ) %>%
  group_by(Variable) %>%
  summarise(
    `Mean` = mean(Value, na.rm = TRUE),
    `SD` = sd(Value, na.rm = TRUE),
    .groups = "drop"
  )
write_csv(stats_table_accuracy_20_50_2_3, "accuracy/stats_table_accuracy_20_50_2_3.csv")


results_20_70_3_3<- read_csv("results_with_D=20,p=70,q=3,K=3.csv")
selected_20_70_3_3_accuracy <- c("best_SEM_accuracy", "best_SEMK_accuracy", "best_SKM_accuracy","best_accuracy")
df_long_20_70_3_3_accuracy <- results_20_70_3_3 %>%
  select(selected_20_70_3_3_accuracy) %>%
  pivot_longer(
    everything(),
    names_to = "Variable",
    values_to = "Value"
  )
df_long_20_70_3_3_accuracy$Variable <- factor(
  df_long_20_70_3_3_accuracy$Variable,
  levels = c("best_accuracy", "best_SEM_accuracy", "best_SEMK_accuracy", "best_SKM_accuracy")
)
plot_accuracy_20_70_3_3<-ggplot(df_long_20_70_3_3_accuracy, aes(x = Variable, y = Value)) +
  geom_boxplot(fill = "skyblue", alpha = 0.7) +
  labs(title = "D=20,p=70,q=3,K=3",
       x="Classification accuracy",
       y = "") +
  theme_minimal()+
  theme(
    plot.title = element_text(size = 40, face = "bold", hjust = 0.5),
    axis.title.x = element_text(size = 30),
    axis.title.y = element_text(size = 30),
    axis.text.x = element_text(size = 15),
    axis.text.y = element_text(size = 15),
    axis.line = element_line(color = "black"),
    panel.border = element_rect(color = "black", fill = NA)
  )+
  scale_x_discrete(labels = c("GSAKM", "SEM", "SEMK", "SKM"))
ggsave("accuracy/Plot_accuracy_20_70_3_3.png",plot=plot_accuracy_20_70_3_3)
stats_table_accuracy_20_70_3_3 <- results_20_70_3_3 %>%
  select(all_of(selected_20_70_3_3_accuracy)) %>%
  pivot_longer(
    everything(),
    names_to = "Variable",
    values_to = "Value"
  ) %>%
  group_by(Variable) %>%
  summarise(
    `Mean` = mean(Value, na.rm = TRUE),
    `SD` = sd(Value, na.rm = TRUE),
    .groups = "drop"
  )
write_csv(stats_table_accuracy_20_70_3_3, "accuracy/stats_table_accuracy_20_70_3_3.csv")


results_20_70_2_3<- read_csv("results_with_D=20,p=70,q=2,K=3.csv")
selected_20_70_2_3_accuracy <- c("best_SEM_accuracy", "best_SEMK_accuracy", "best_SKM_accuracy","best_accuracy")
df_long_20_70_2_3_accuracy <- results_20_70_2_3 %>%
  select(selected_20_70_2_3_accuracy) %>%
  pivot_longer(
    everything(),
    names_to = "Variable",
    values_to = "Value"
  )
df_long_20_70_2_3_accuracy$Variable <- factor(
  df_long_20_70_2_3_accuracy$Variable,
  levels = c("best_accuracy", "best_SEM_accuracy", "best_SEMK_accuracy", "best_SKM_accuracy")
)
plot_accuracy_20_70_2_3<-ggplot(df_long_20_70_2_3_accuracy, aes(x = Variable, y = Value)) +
  geom_boxplot(fill = "skyblue", alpha = 0.7) +
  labs(title = "D=20,p=70,q=2,K=3",
       x="Classification accuracy",
       y = "") +
  theme_minimal()+
  theme(
    plot.title = element_text(size = 40, face = "bold", hjust = 0.5),
    axis.title.x = element_text(size = 30),
    axis.title.y = element_text(size = 30),
    axis.text.x = element_text(size = 15),
    axis.text.y = element_text(size = 15),
    axis.line = element_line(color = "black"),
    panel.border = element_rect(color = "black", fill = NA)
  )+
  scale_x_discrete(labels = c("GSAKM", "SEM", "SEMK", "SKM"))
ggsave("accuracy/Plot_accuracy_20_70_2_3.png",plot=plot_accuracy_20_70_2_3)
stats_table_accuracy_20_70_2_3 <- results_20_70_2_3 %>%
  select(all_of(selected_20_70_2_3_accuracy)) %>%
  pivot_longer(
    everything(),
    names_to = "Variable",
    values_to = "Value"
  ) %>%
  group_by(Variable) %>%
  summarise(
    `Mean` = mean(Value, na.rm = TRUE),
    `SD` = sd(Value, na.rm = TRUE),
    .groups = "drop"
  )
write_csv(stats_table_accuracy_20_70_2_3, "accuracy/stats_table_accuracy_20_70_2_3.csv")


results_20_50_3_4<- read_csv("results_with_D=20,p=50,q=3,K=4.csv")
selected_20_50_3_4_accuracy <- c("best_SEM_accuracy", "best_SEMK_accuracy", "best_SKM_accuracy","best_accuracy")
df_long_20_50_3_4_accuracy <- results_20_50_3_4 %>%
  select(selected_20_50_3_4_accuracy) %>%
  pivot_longer(
    everything(),
    names_to = "Variable",
    values_to = "Value"
  )
df_long_20_50_3_4_accuracy$Variable <- factor(
  df_long_20_50_3_4_accuracy$Variable,
  levels = c("best_accuracy", "best_SEM_accuracy", "best_SEMK_accuracy", "best_SKM_accuracy")
)
plot_accuracy_20_50_3_4<-ggplot(df_long_20_50_3_4_accuracy, aes(x = Variable, y = Value)) +
  geom_boxplot(fill = "skyblue", alpha = 0.7) +
  labs(title = "D=20,p=50,q=3,K=4",
       x="Classification accuracy",
       y = "") +
  theme_minimal()+
  theme(
    plot.title = element_text(size = 40, face = "bold", hjust = 0.5),
    axis.title.x = element_text(size = 30),
    axis.title.y = element_text(size = 30),
    axis.text.x = element_text(size = 15),
    axis.text.y = element_text(size = 15),
    axis.line = element_line(color = "black"),
    panel.border = element_rect(color = "black", fill = NA)
  )+
  scale_x_discrete(labels = c("GSAKM", "SEM", "SEMK", "SKM"))
ggsave("accuracy/Plot_accuracy_20_50_3_4.png",plot=plot_accuracy_20_50_3_4)
stats_table_accuracy_20_50_3_4 <- results_20_50_3_4 %>%
  select(all_of(selected_20_50_3_4_accuracy)) %>%
  pivot_longer(
    everything(),
    names_to = "Variable",
    values_to = "Value"
  ) %>%
  group_by(Variable) %>%
  summarise(
    `Mean` = mean(Value, na.rm = TRUE),
    `SD` = sd(Value, na.rm = TRUE),
    .groups = "drop"
  )
write_csv(stats_table_accuracy_20_50_3_4, "accuracy/stats_table_accuracy_20_50_3_4.csv")


results_20_50_2_4<- read_csv("results_with_D=20,p=50,q=2,K=4.csv")
selected_20_50_2_4_accuracy <- c("best_SEM_accuracy", "best_SEMK_accuracy", "best_SKM_accuracy","best_accuracy")
df_long_20_50_2_4_accuracy <- results_20_50_2_4 %>%
  select(selected_20_50_2_4_accuracy) %>%
  pivot_longer(
    everything(),
    names_to = "Variable",
    values_to = "Value"
  )
df_long_20_50_2_4_accuracy$Variable <- factor(
  df_long_20_50_2_4_accuracy$Variable,
  levels = c("best_accuracy", "best_SEM_accuracy", "best_SEMK_accuracy", "best_SKM_accuracy")
)
plot_accuracy_20_50_2_4<-ggplot(df_long_20_50_2_4_accuracy, aes(x = Variable, y = Value)) +
  geom_boxplot(fill = "skyblue", alpha = 0.7) +
  labs(title = "D=20,p=50,q=2,K=4",
       x="Classification accuracy",
       y = "") +
  theme_minimal()+
  theme(
    plot.title = element_text(size = 40, face = "bold", hjust = 0.5),
    axis.title.x = element_text(size = 30),
    axis.title.y = element_text(size = 30),
    axis.text.x = element_text(size = 15),
    axis.text.y = element_text(size = 15),
    axis.line = element_line(color = "black"),
    panel.border = element_rect(color = "black", fill = NA)
  )+
  scale_x_discrete(labels = c("GSAKM", "SEM", "SEMK", "SKM"))
ggsave("accuracy/Plot_accuracy_20_50_2_4.png",plot=plot_accuracy_20_50_2_4)
stats_table_accuracy_20_50_2_4 <- results_20_50_2_4 %>%
  select(all_of(selected_20_50_2_4_accuracy)) %>%
  pivot_longer(
    everything(),
    names_to = "Variable",
    values_to = "Value"
  ) %>%
  group_by(Variable) %>%
  summarise(
    `Mean` = mean(Value, na.rm = TRUE),
    `SD` = sd(Value, na.rm = TRUE),
    .groups = "drop"
  )
write_csv(stats_table_accuracy_20_50_2_4, "accuracy/stats_table_accuracy_20_50_2_4.csv")


results_20_35_3_4<- read_csv("results_with_D=20,p=35,q=3,K=4.csv")
selected_20_35_3_4_accuracy <- c("best_SEM_accuracy", "best_SEMK_accuracy", "best_SKM_accuracy","best_accuracy")
df_long_20_35_3_4_accuracy <- results_20_35_3_4 %>%
  select(selected_20_35_3_4_accuracy) %>%
  pivot_longer(
    everything(),
    names_to = "Variable",
    values_to = "Value"
  )
df_long_20_35_3_4_accuracy$Variable <- factor(
  df_long_20_35_3_4_accuracy$Variable,
  levels = c("best_accuracy", "best_SEM_accuracy", "best_SEMK_accuracy", "best_SKM_accuracy")
)
plot_accuracy_20_35_3_4<-ggplot(df_long_20_35_3_4_accuracy, aes(x = Variable, y = Value)) +
  geom_boxplot(fill = "skyblue", alpha = 0.7) +
  labs(title = "D=20,p=35,q=3,K=4",
       x="Classification accuracy",
       y = "") +
  theme_minimal()+
  theme(
    plot.title = element_text(size = 40, face = "bold", hjust = 0.5),
    axis.title.x = element_text(size = 30),
    axis.title.y = element_text(size = 30),
    axis.text.x = element_text(size = 15),
    axis.text.y = element_text(size = 15),
    axis.line = element_line(color = "black"),
    panel.border = element_rect(color = "black", fill = NA)
  )+
  scale_x_discrete(labels = c("GSAKM", "SEM", "SEMK", "SKM"))
ggsave("accuracy/Plot_accuracy_20_35_3_4.png",plot=plot_accuracy_20_35_3_4)
stats_table_accuracy_20_35_3_4 <- results_20_35_3_4 %>%
  select(all_of(selected_20_35_3_4_accuracy)) %>%
  pivot_longer(
    everything(),
    names_to = "Variable",
    values_to = "Value"
  ) %>%
  group_by(Variable) %>%
  summarise(
    `Mean` = mean(Value, na.rm = TRUE),
    `SD` = sd(Value, na.rm = TRUE),
    .groups = "drop"
  )
write_csv(stats_table_accuracy_20_35_3_4, "accuracy/stats_table_accuracy_20_35_3_4.csv")


results_20_35_2_4<- read_csv("results_with_D=20,p=35,q=2,K=4.csv")
selected_20_35_2_4_accuracy <- c("best_SEM_accuracy", "best_SEMK_accuracy", "best_SKM_accuracy","best_accuracy")
df_long_20_35_2_4_accuracy <- results_20_35_2_4 %>%
  select(selected_20_35_2_4_accuracy) %>%
  pivot_longer(
    everything(),
    names_to = "Variable",
    values_to = "Value"
  )
df_long_20_35_2_4_accuracy$Variable <- factor(
  df_long_20_35_2_4_accuracy$Variable,
  levels = c("best_accuracy", "best_SEM_accuracy", "best_SEMK_accuracy", "best_SKM_accuracy")
)
plot_accuracy_20_35_2_4<-ggplot(df_long_20_35_2_4_accuracy, aes(x = Variable, y = Value)) +
  geom_boxplot(fill = "skyblue", alpha = 0.7) +
  labs(title = "D=20,p=35,q=2,K=4",
       x="Classification accuracy",
       y = "") +
  theme_minimal()+
  theme(
    plot.title = element_text(size = 40, face = "bold", hjust = 0.5),
    axis.title.x = element_text(size = 30),
    axis.title.y = element_text(size = 30),
    axis.text.x = element_text(size = 15),
    axis.text.y = element_text(size = 15),
    axis.line = element_line(color = "black"),
    panel.border = element_rect(color = "black", fill = NA)
  )+
  scale_x_discrete(labels = c("GSAKM", "SEM", "SEMK", "SKM"))
ggsave("accuracy/Plot_accuracy_20_35_2_4.png",plot=plot_accuracy_20_35_2_4)
stats_table_accuracy_20_35_2_4 <- results_20_35_2_4 %>%
  select(all_of(selected_20_35_2_4_accuracy)) %>%
  pivot_longer(
    everything(),
    names_to = "Variable",
    values_to = "Value"
  ) %>%
  group_by(Variable) %>%
  summarise(
    `Mean` = mean(Value, na.rm = TRUE),
    `SD` = sd(Value, na.rm = TRUE),
    .groups = "drop"
  )
write_csv(stats_table_accuracy_20_35_2_4, "accuracy/stats_table_accuracy_20_35_2_4.csv")

results_40_50_3_3<- read_csv("results_with_D=40,p=50,q=3,K=3.csv")
selected_40_50_3_3_accuracy <- c("best_SEM_accuracy", "best_SEMK_accuracy", "best_SKM_accuracy","best_accuracy")
df_long_40_50_3_3_accuracy <- results_40_50_3_3 %>%
  select(selected_40_50_3_3_accuracy) %>%
  pivot_longer(
    everything(),
    names_to = "Variable",
    values_to = "Value"
  )
df_long_40_50_3_3_accuracy$Variable <- factor(
  df_long_40_50_3_3_accuracy$Variable,
  levels = c("best_accuracy", "best_SEM_accuracy", "best_SEMK_accuracy", "best_SKM_accuracy")
)
plot_accuracy_40_50_3_3<-ggplot(df_long_40_50_3_3_accuracy, aes(x = Variable, y = Value)) +
  geom_boxplot(fill = "skyblue", alpha = 0.7) +
  labs(title = "D=40,p=50,q=3,K=3",
       x="Classification accuracy",
       y = "") +
  theme_minimal()+
  theme(
    plot.title = element_text(size = 40, face = "bold", hjust = 0.5),
    axis.title.x = element_text(size = 30),
    axis.title.y = element_text(size = 30),
    axis.text.x = element_text(size = 15),
    axis.text.y = element_text(size = 15),
    axis.line = element_line(color = "black"),
    panel.border = element_rect(color = "black", fill = NA)
  )+
  scale_x_discrete(labels = c("GSAKM", "SEM", "SEMK", "SKM"))
ggsave("accuracy/Plot_accuracy_40_50_3_3.png",plot=plot_accuracy_40_50_3_3)
stats_table_accuracy_40_50_3_3 <- results_40_50_3_3 %>%
  select(all_of(selected_40_50_3_3_accuracy)) %>%
  pivot_longer(
    everything(),
    names_to = "Variable",
    values_to = "Value"
  ) %>%
  group_by(Variable) %>%
  summarise(
    `Mean` = mean(Value, na.rm = TRUE),
    `SD` = sd(Value, na.rm = TRUE),
    .groups = "drop"
  )
write_csv(stats_table_accuracy_40_50_3_3, "accuracy/stats_table_accuracy_40_50_3_3.csv")


results_40_50_2_3<- read_csv("results_with_D=40,p=50,q=2,K=3.csv")
selected_40_50_2_3_accuracy <- c("best_SEM_accuracy", "best_SEMK_accuracy", "best_SKM_accuracy","best_accuracy")
df_long_40_50_2_3_accuracy <- results_40_50_2_3 %>%
  select(selected_40_50_2_3_accuracy) %>%
  pivot_longer(
    everything(),
    names_to = "Variable",
    values_to = "Value"
  )
df_long_40_50_2_3_accuracy$Variable <- factor(
  df_long_40_50_2_3_accuracy$Variable,
  levels = c("best_accuracy", "best_SEM_accuracy", "best_SEMK_accuracy", "best_SKM_accuracy")
)
plot_accuracy_40_50_2_3<-ggplot(df_long_40_50_2_3_accuracy, aes(x = Variable, y = Value)) +
  geom_boxplot(fill = "skyblue", alpha = 0.7) +
  labs(title = "D=40,p=50,q=2,K=3",
       x="Classification accuracy",
       y = "") +
  theme_minimal()+
  theme(
    plot.title = element_text(size = 40, face = "bold", hjust = 0.5),
    axis.title.x = element_text(size = 30),
    axis.title.y = element_text(size = 30),
    axis.text.x = element_text(size = 15),
    axis.text.y = element_text(size = 15),
    axis.line = element_line(color = "black"),
    panel.border = element_rect(color = "black", fill = NA)
  )+
  scale_x_discrete(labels = c("GSAKM", "SEM", "SEMK", "SKM"))
ggsave("accuracy/Plot_accuracy_40_50_2_3.png",plot=plot_accuracy_40_50_2_3)
stats_table_accuracy_40_50_2_3 <- results_40_50_2_3 %>%
  select(all_of(selected_40_50_2_3_accuracy)) %>%
  pivot_longer(
    everything(),
    names_to = "Variable",
    values_to = "Value"
  ) %>%
  group_by(Variable) %>%
  summarise(
    `Mean` = mean(Value, na.rm = TRUE),
    `SD` = sd(Value, na.rm = TRUE),
    .groups = "drop"
  )
write_csv(stats_table_accuracy_40_50_2_3, "accuracy/stats_table_accuracy_40_50_2_3.csv")


results_40_70_3_3<- read_csv("results_with_D=40,p=70,q=3,K=3.csv")
selected_40_70_3_3_accuracy <- c("best_SEM_accuracy", "best_SEMK_accuracy", "best_SKM_accuracy","best_accuracy")
df_long_40_70_3_3_accuracy <- results_40_70_3_3 %>%
  select(selected_40_70_3_3_accuracy) %>%
  pivot_longer(
    everything(),
    names_to = "Variable",
    values_to = "Value"
  )
df_long_40_70_3_3_accuracy$Variable <- factor(
  df_long_40_70_3_3_accuracy$Variable,
  levels = c("best_accuracy", "best_SEM_accuracy", "best_SEMK_accuracy", "best_SKM_accuracy")
)
plot_accuracy_40_70_3_3<-ggplot(df_long_40_70_3_3_accuracy, aes(x = Variable, y = Value)) +
  geom_boxplot(fill = "skyblue", alpha = 0.7) +
  labs(title = "D=40,p=70,q=3,K=3",
       x="Classification accuracy",
       y = "") +
  theme_minimal()+
  theme(
    plot.title = element_text(size = 40, face = "bold", hjust = 0.5),
    axis.title.x = element_text(size = 30),
    axis.title.y = element_text(size = 30),
    axis.text.x = element_text(size = 15),
    axis.text.y = element_text(size = 15),
    axis.line = element_line(color = "black"),
    panel.border = element_rect(color = "black", fill = NA)
  )+
  scale_x_discrete(labels = c("GSAKM", "SEM", "SEMK", "SKM"))
ggsave("accuracy/Plot_accuracy_40_70_3_3.png",plot=plot_accuracy_40_70_3_3)
stats_table_accuracy_40_70_3_3 <- results_40_70_3_3 %>%
  select(all_of(selected_40_70_3_3_accuracy)) %>%
  pivot_longer(
    everything(),
    names_to = "Variable",
    values_to = "Value"
  ) %>%
  group_by(Variable) %>%
  summarise(
    `Mean` = mean(Value, na.rm = TRUE),
    `SD` = sd(Value, na.rm = TRUE),
    .groups = "drop"
  )
write_csv(stats_table_accuracy_40_70_3_3, "accuracy/stats_table_accuracy_40_70_3_3.csv")


results_40_70_2_3<- read_csv("results_with_D=40,p=70,q=2,K=3.csv")
selected_40_70_2_3_accuracy <- c("best_SEM_accuracy", "best_SEMK_accuracy", "best_SKM_accuracy","best_accuracy")
df_long_40_70_2_3_accuracy <- results_40_70_2_3 %>%
  select(selected_40_70_2_3_accuracy) %>%
  pivot_longer(
    everything(),
    names_to = "Variable",
    values_to = "Value"
  )
df_long_40_70_2_3_accuracy$Variable <- factor(
  df_long_40_70_2_3_accuracy$Variable,
  levels = c("best_accuracy", "best_SEM_accuracy", "best_SEMK_accuracy", "best_SKM_accuracy")
)
plot_accuracy_40_70_2_3<-ggplot(df_long_40_70_2_3_accuracy, aes(x = Variable, y = Value)) +
  geom_boxplot(fill = "skyblue", alpha = 0.7) +
  labs(title = "D=40,p=70,q=2,K=3",
       x="Classification accuracy",
       y = "") +
  theme_minimal()+
  theme(
    plot.title = element_text(size = 40, face = "bold", hjust = 0.5),
    axis.title.x = element_text(size = 30),
    axis.title.y = element_text(size = 30),
    axis.text.x = element_text(size = 15),
    axis.text.y = element_text(size = 15),
    axis.line = element_line(color = "black"),
    panel.border = element_rect(color = "black", fill = NA)
  )+
  scale_x_discrete(labels = c("GSAKM", "SEM", "SEMK", "SKM"))
ggsave("accuracy/Plot_accuracy_40_70_2_3.png",plot=plot_accuracy_40_70_2_3)
stats_table_accuracy_40_70_2_3 <- results_40_70_2_3 %>%
  select(all_of(selected_40_70_2_3_accuracy)) %>%
  pivot_longer(
    everything(),
    names_to = "Variable",
    values_to = "Value"
  ) %>%
  group_by(Variable) %>%
  summarise(
    `Mean` = mean(Value, na.rm = TRUE),
    `SD` = sd(Value, na.rm = TRUE),
    .groups = "drop"
  )
write_csv(stats_table_accuracy_40_70_2_3, "accuracy/stats_table_accuracy_40_70_2_3.csv")


results_40_50_3_4<- read_csv("results_with_D=40,p=50,q=3,K=4.csv")
selected_40_50_3_4_accuracy <- c("best_SEM_accuracy", "best_SEMK_accuracy", "best_SKM_accuracy","best_accuracy")
df_long_40_50_3_4_accuracy <- results_40_50_3_4 %>%
  select(selected_40_50_3_4_accuracy) %>%
  pivot_longer(
    everything(),
    names_to = "Variable",
    values_to = "Value"
  )
df_long_40_50_3_4_accuracy$Variable <- factor(
  df_long_40_50_3_4_accuracy$Variable,
  levels = c("best_accuracy", "best_SEM_accuracy", "best_SEMK_accuracy", "best_SKM_accuracy")
)
plot_accuracy_40_50_3_4<-ggplot(df_long_40_50_3_4_accuracy, aes(x = Variable, y = Value)) +
  geom_boxplot(fill = "skyblue", alpha = 0.7) +
  labs(title = "D=40,p=50,q=3,K=4",
       x="Classification accuracy",
       y = "") +
  theme_minimal()+
  theme(
    plot.title = element_text(size = 40, face = "bold", hjust = 0.5),
    axis.title.x = element_text(size = 30),
    axis.title.y = element_text(size = 30),
    axis.text.x = element_text(size = 15),
    axis.text.y = element_text(size = 15),
    axis.line = element_line(color = "black"),
    panel.border = element_rect(color = "black", fill = NA)
  )+
  scale_x_discrete(labels = c("GSAKM", "SEM", "SEMK", "SKM"))
ggsave("accuracy/Plot_accuracy_40_50_3_4.png",plot=plot_accuracy_40_50_3_4)
stats_table_accuracy_40_50_3_4 <- results_40_50_3_4 %>%
  select(all_of(selected_40_50_3_4_accuracy)) %>%
  pivot_longer(
    everything(),
    names_to = "Variable",
    values_to = "Value"
  ) %>%
  group_by(Variable) %>%
  summarise(
    `Mean` = mean(Value, na.rm = TRUE),
    `SD` = sd(Value, na.rm = TRUE),
    .groups = "drop"
  )
write_csv(stats_table_accuracy_40_50_3_4, "accuracy/stats_table_accuracy_40_50_3_4.csv")


results_40_50_2_4<- read_csv("results_with_D=40,p=50,q=2,K=4.csv")
selected_40_50_2_4_accuracy <- c("best_SEM_accuracy", "best_SEMK_accuracy", "best_SKM_accuracy","best_accuracy")
df_long_40_50_2_4_accuracy <- results_40_50_2_4 %>%
  select(selected_40_50_2_4_accuracy) %>%
  pivot_longer(
    everything(),
    names_to = "Variable",
    values_to = "Value"
  )
df_long_40_50_2_4_accuracy$Variable <- factor(
  df_long_40_50_2_4_accuracy$Variable,
  levels = c("best_accuracy", "best_SEM_accuracy", "best_SEMK_accuracy", "best_SKM_accuracy")
)
plot_accuracy_40_50_2_4<-ggplot(df_long_40_50_2_4_accuracy, aes(x = Variable, y = Value)) +
  geom_boxplot(fill = "skyblue", alpha = 0.7) +
  labs(title = "D=40,p=50,q=2,K=4",
       x="Classification accuracy",
       y = "") +
  theme_minimal()+
  theme(
    plot.title = element_text(size = 40, face = "bold", hjust = 0.5),
    axis.title.x = element_text(size = 30),
    axis.title.y = element_text(size = 30),
    axis.text.x = element_text(size = 15),
    axis.text.y = element_text(size = 15),
    axis.line = element_line(color = "black"),
    panel.border = element_rect(color = "black", fill = NA)
  )+
  scale_x_discrete(labels = c("GSAKM", "SEM", "SEMK", "SKM"))
ggsave("accuracy/Plot_accuracy_40_50_2_4.png",plot=plot_accuracy_40_50_2_4)
stats_table_accuracy_40_50_2_4 <- results_40_50_2_4 %>%
  select(all_of(selected_40_50_2_4_accuracy)) %>%
  pivot_longer(
    everything(),
    names_to = "Variable",
    values_to = "Value"
  ) %>%
  group_by(Variable) %>%
  summarise(
    `Mean` = mean(Value, na.rm = TRUE),
    `SD` = sd(Value, na.rm = TRUE),
    .groups = "drop"
  )
write_csv(stats_table_accuracy_40_50_2_4, "accuracy/stats_table_accuracy_40_50_2_4.csv")


results_40_35_3_4<- read_csv("results_with_D=40,p=35,q=3,K=4.csv")
selected_40_35_3_4_accuracy <- c("best_SEM_accuracy", "best_SEMK_accuracy", "best_SKM_accuracy","best_accuracy")
df_long_40_35_3_4_accuracy <- results_40_35_3_4 %>%
  select(selected_40_35_3_4_accuracy) %>%
  pivot_longer(
    everything(),
    names_to = "Variable",
    values_to = "Value"
  )
df_long_40_35_3_4_accuracy$Variable <- factor(
  df_long_40_35_3_4_accuracy$Variable,
  levels = c("best_accuracy", "best_SEM_accuracy", "best_SEMK_accuracy", "best_SKM_accuracy")
)
plot_accuracy_40_35_3_4<-ggplot(df_long_40_35_3_4_accuracy, aes(x = Variable, y = Value)) +
  geom_boxplot(fill = "skyblue", alpha = 0.7) +
  labs(title = "D=40,p=35,q=3,K=4",
       x="Classification accuracy",
       y = "") +
  theme_minimal()+
  theme(
    plot.title = element_text(size = 40, face = "bold", hjust = 0.5),
    axis.title.x = element_text(size = 30),
    axis.title.y = element_text(size = 30),
    axis.text.x = element_text(size = 15),
    axis.text.y = element_text(size = 15),
    axis.line = element_line(color = "black"),
    panel.border = element_rect(color = "black", fill = NA)
  )+
  scale_x_discrete(labels = c("GSAKM", "SEM", "SEMK", "SKM"))
ggsave("accuracy/Plot_accuracy_40_35_3_4.png",plot=plot_accuracy_40_35_3_4)
stats_table_accuracy_40_35_3_4 <- results_40_35_3_4 %>%
  select(all_of(selected_40_35_3_4_accuracy)) %>%
  pivot_longer(
    everything(),
    names_to = "Variable",
    values_to = "Value"
  ) %>%
  group_by(Variable) %>%
  summarise(
    `Mean` = mean(Value, na.rm = TRUE),
    `SD` = sd(Value, na.rm = TRUE),
    .groups = "drop"
  )
write_csv(stats_table_accuracy_40_35_3_4, "accuracy/stats_table_accuracy_40_35_3_4.csv")


results_40_35_2_4<- read_csv("results_with_D=40,p=35,q=2,K=4.csv")
selected_40_35_2_4_accuracy <- c("best_SEM_accuracy", "best_SEMK_accuracy", "best_SKM_accuracy","best_accuracy")
df_long_40_35_2_4_accuracy <- results_40_35_2_4 %>%
  select(selected_40_35_2_4_accuracy) %>%
  pivot_longer(
    everything(),
    names_to = "Variable",
    values_to = "Value"
  )
df_long_40_35_2_4_accuracy$Variable <- factor(
  df_long_40_35_2_4_accuracy$Variable,
  levels = c("best_accuracy", "best_SEM_accuracy", "best_SEMK_accuracy", "best_SKM_accuracy")
)
plot_accuracy_40_35_2_4<-ggplot(df_long_40_35_2_4_accuracy, aes(x = Variable, y = Value)) +
  geom_boxplot(fill = "skyblue", alpha = 0.7) +
  labs(title = "D=40,p=35,q=2,K=4",
       x="Classification accuracy",
       y = "") +
  theme_minimal()+
  theme(
    plot.title = element_text(size = 40, face = "bold", hjust = 0.5),
    axis.title.x = element_text(size = 30),
    axis.title.y = element_text(size = 30),
    axis.text.x = element_text(size = 15),
    axis.text.y = element_text(size = 15),
    axis.line = element_line(color = "black"),
    panel.border = element_rect(color = "black", fill = NA)
  )+
  scale_x_discrete(labels = c("GSAKM", "SEM", "SEMK", "SKM"))
ggsave("accuracy/Plot_accuracy_40_35_2_4.png",plot=plot_accuracy_40_35_2_4)
stats_table_accuracy_40_35_2_4 <- results_40_35_2_4 %>%
  select(all_of(selected_40_35_2_4_accuracy)) %>%
  pivot_longer(
    everything(),
    names_to = "Variable",
    values_to = "Value"
  ) %>%
  group_by(Variable) %>%
  summarise(
    `Mean` = mean(Value, na.rm = TRUE),
    `SD` = sd(Value, na.rm = TRUE),
    .groups = "drop"
  )
write_csv(stats_table_accuracy_40_35_2_4, "accuracy/stats_table_accuracy_40_35_2_4.csv")