library(tidyverse)
library(readr)
library(ggplot2)
library(tidyr)
if (!dir.exists("metric")) {
  dir.create("metric")
}
results_20_50_3_3<- read_csv("results_with_D=20,p=50,q=3,K=3.csv")
selected_20_50_3_3_metric <- c("best_SEM_metric", "best_SEMK_metric", "best_SKM_metric","best_metric")
df_long_20_50_3_3_metric <- results_20_50_3_3 %>%
  select(selected_20_50_3_3_metric) %>%
  pivot_longer(
    everything(),
    names_to = "Variable",
    values_to = "Value"
  )
plot_metric_20_50_3_3<-ggplot(df_long_20_50_3_3_metric, aes(x = Variable, y = Value)) +
  geom_boxplot(fill = "skyblue", alpha = 0.7) +
  labs(title = "D=20,p=50,q=3,K=3",
       x="Within-cluster sum of squares",
       y = "") +
  theme_minimal()+
  theme(
    plot.title = element_text(size = 40, face = "bold", hjust = 0.5),
    axis.title.x = element_text(size = 30),
    axis.title.y = element_text(size = 30),
    axis.text.x = element_text(size = 15),
    axis.text.y = element_text(size = 15),     
    axis.line = element_line(color = "black"),
    panel.border = element_rect(color = "black", fill = NA)
  )+
  scale_x_discrete(labels = c("GSAKM", "SEM", "SEMK", "SKM"))
ggsave("metric/Plot_metric_20_50_3_3.png",plot=plot_metric_20_50_3_3)
stats_table_metric_20_50_3_3 <- results_20_50_3_3 %>%
  select(all_of(selected_20_50_3_3_metric)) %>%
  pivot_longer(
    everything(),
    names_to = "Variable",
    values_to = "Value"
  ) %>%
  group_by(Variable) %>%
  summarise(
    `Mean` = mean(Value, na.rm = TRUE),
    `SD` = sd(Value, na.rm = TRUE),
    .groups = "drop"
  )
write_csv(stats_table_metric_20_50_3_3, "metric/stats_table_metric_20_50_3_3.csv")


results_20_50_2_3<- read_csv("results_with_D=20,p=50,q=2,K=3.csv")
selected_20_50_2_3_metric <- c("best_SEM_metric", "best_SEMK_metric", "best_SKM_metric","best_metric")
df_long_20_50_2_3_metric <- results_20_50_2_3 %>%
  select(selected_20_50_2_3_metric) %>%
  pivot_longer(
    everything(),
    names_to = "Variable",
    values_to = "Value"
  )
plot_metric_20_50_2_3<-ggplot(df_long_20_50_2_3_metric, aes(x = Variable, y = Value)) +
  geom_boxplot(fill = "skyblue", alpha = 0.7) +
  labs(title = "D=20,p=50,q=2,K=3",
       x="Within-cluster sum of squares",
       y = "") +
  theme_minimal()+
  theme(
    plot.title = element_text(size = 40, face = "bold", hjust = 0.5),
    axis.title.x = element_text(size = 30),
    axis.title.y = element_text(size = 30),
    axis.text.x = element_text(size = 15),
    axis.text.y = element_text(size = 15), 
    axis.line = element_line(color = "black"),
    panel.border = element_rect(color = "black", fill = NA)
  )+
  scale_x_discrete(labels = c("GSAKM", "SEM", "SEMK", "SKM"))
ggsave("metric/Plot_metric_20_50_2_3.png",plot=plot_metric_20_50_2_3)
stats_table_metric_20_50_2_3 <- results_20_50_2_3 %>%
  select(all_of(selected_20_50_2_3_metric)) %>%
  pivot_longer(
    everything(),
    names_to = "Variable",
    values_to = "Value"
  ) %>%
  group_by(Variable) %>%
  summarise(
    `Mean` = mean(Value, na.rm = TRUE),
    `SD` = sd(Value, na.rm = TRUE),
    .groups = "drop"
  )
write_csv(stats_table_metric_20_50_2_3, "metric/stats_table_metric_20_50_2_3.csv")


results_20_70_3_3<- read_csv("results_with_D=20,p=70,q=3,K=3.csv")
selected_20_70_3_3_metric <- c("best_SEM_metric", "best_SEMK_metric", "best_SKM_metric","best_metric")
df_long_20_70_3_3_metric <- results_20_70_3_3 %>%
  select(selected_20_70_3_3_metric) %>%
  pivot_longer(
    everything(),
    names_to = "Variable",
    values_to = "Value"
  )
plot_metric_20_70_3_3<-ggplot(df_long_20_70_3_3_metric, aes(x = Variable, y = Value)) +
  geom_boxplot(fill = "skyblue", alpha = 0.7) +
  labs(title = "D=20,p=70,q=3,K=3",
       x="Within-cluster sum of squares",
       y = "") +
  theme_minimal()+
  theme(
    plot.title = element_text(size = 40, face = "bold", hjust = 0.5),
    axis.title.x = element_text(size = 30),
    axis.title.y = element_text(size = 30),
    axis.text.x = element_text(size = 15),
    axis.text.y = element_text(size = 15),
    axis.line = element_line(color = "black"),
    panel.border = element_rect(color = "black", fill = NA)
  )+
  scale_x_discrete(labels = c("GSAKM", "SEM", "SEMK", "SKM"))
ggsave("metric/Plot_metric_20_70_3_3.png",plot=plot_metric_20_70_3_3)
stats_table_metric_20_70_3_3 <- results_20_70_3_3 %>%
  select(all_of(selected_20_70_3_3_metric)) %>%
  pivot_longer(
    everything(),
    names_to = "Variable",
    values_to = "Value"
  ) %>%
  group_by(Variable) %>%
  summarise(
    `Mean` = mean(Value, na.rm = TRUE),
    `SD` = sd(Value, na.rm = TRUE),
    .groups = "drop"
  )
write_csv(stats_table_metric_20_70_3_3, "metric/stats_table_metric_20_70_3_3.csv")


results_20_70_2_3<- read_csv("results_with_D=20,p=70,q=2,K=3.csv")
selected_20_70_2_3_metric <- c("best_SEM_metric", "best_SEMK_metric", "best_SKM_metric","best_metric")
df_long_20_70_2_3_metric <- results_20_70_2_3 %>%
  select(selected_20_70_2_3_metric) %>%
  pivot_longer(
    everything(),
    names_to = "Variable",
    values_to = "Value"
  )
plot_metric_20_70_2_3<-ggplot(df_long_20_70_2_3_metric, aes(x = Variable, y = Value)) +
  geom_boxplot(fill = "skyblue", alpha = 0.7) +
  labs(title = "D=20,p=70,q=2,K=3",
       x="Within-cluster sum of squares",
       y = "") +
  theme_minimal()+
  theme(
    plot.title = element_text(size = 40, face = "bold", hjust = 0.5),
    axis.title.x = element_text(size = 30),
    axis.title.y = element_text(size = 30),
    axis.text.x = element_text(size = 15),
    axis.text.y = element_text(size = 15),
    axis.line = element_line(color = "black"),
    panel.border = element_rect(color = "black", fill = NA)
  )+
  scale_x_discrete(labels = c("GSAKM", "SEM", "SEMK", "SKM"))
ggsave("metric/Plot_metric_20_70_2_3.png",plot=plot_metric_20_70_2_3)
stats_table_metric_20_70_2_3 <- results_20_70_2_3 %>%
  select(all_of(selected_20_70_2_3_metric)) %>%
  pivot_longer(
    everything(),
    names_to = "Variable",
    values_to = "Value"
  ) %>%
  group_by(Variable) %>%
  summarise(
    `Mean` = mean(Value, na.rm = TRUE),
    `SD` = sd(Value, na.rm = TRUE),
    .groups = "drop"
  )
write_csv(stats_table_metric_20_70_2_3, "metric/stats_table_metric_20_70_2_3.csv")


results_20_50_3_4<- read_csv("results_with_D=20,p=50,q=3,K=4.csv")
selected_20_50_3_4_metric <- c("best_SEM_metric", "best_SEMK_metric", "best_SKM_metric","best_metric")
df_long_20_50_3_4_metric <- results_20_50_3_4 %>%
  select(selected_20_50_3_4_metric) %>%
  pivot_longer(
    everything(),
    names_to = "Variable",
    values_to = "Value"
  )
plot_metric_20_50_3_4<-ggplot(df_long_20_50_3_4_metric, aes(x = Variable, y = Value)) +
  geom_boxplot(fill = "skyblue", alpha = 0.7) +
  labs(title = "D=20,p=50,q=3,K=4",
       x="Within-cluster sum of squares",
       y = "") +
  theme_minimal()+
  theme(
    plot.title = element_text(size = 40, face = "bold", hjust = 0.5),
    axis.title.x = element_text(size = 30),
    axis.title.y = element_text(size = 30),
    axis.text.x = element_text(size = 15),
    axis.text.y = element_text(size = 15),
    axis.line = element_line(color = "black"),
    panel.border = element_rect(color = "black", fill = NA)
  )+
  scale_x_discrete(labels = c("GSAKM", "SEM", "SEMK", "SKM"))
ggsave("metric/Plot_metric_20_50_3_4.png",plot=plot_metric_20_50_3_4)
stats_table_metric_20_50_3_4 <- results_20_50_3_4 %>%
  select(all_of(selected_20_50_3_4_metric)) %>%
  pivot_longer(
    everything(),
    names_to = "Variable",
    values_to = "Value"
  ) %>%
  group_by(Variable) %>%
  summarise(
    `Mean` = mean(Value, na.rm = TRUE),
    `SD` = sd(Value, na.rm = TRUE),
    .groups = "drop"
  )
write_csv(stats_table_metric_20_50_3_4, "metric/stats_table_metric_20_50_3_4.csv")


results_20_50_2_4<- read_csv("results_with_D=20,p=50,q=2,K=4.csv")
selected_20_50_2_4_metric <- c("best_SEM_metric", "best_SEMK_metric", "best_SKM_metric","best_metric")
df_long_20_50_2_4_metric <- results_20_50_2_4 %>%
  select(selected_20_50_2_4_metric) %>%
  pivot_longer(
    everything(),
    names_to = "Variable",
    values_to = "Value"
  )
plot_metric_20_50_2_4<-ggplot(df_long_20_50_2_4_metric, aes(x = Variable, y = Value)) +
  geom_boxplot(fill = "skyblue", alpha = 0.7) +
  labs(title = "D=20,p=50,q=2,K=4",
       x="Within-cluster sum of squares",
       y = "") +
  theme_minimal()+
  theme(
    plot.title = element_text(size = 40, face = "bold", hjust = 0.5),
    axis.title.x = element_text(size = 30),
    axis.title.y = element_text(size = 30),
    axis.text.x = element_text(size = 15),
    axis.text.y = element_text(size = 15),
    axis.line = element_line(color = "black"),
    panel.border = element_rect(color = "black", fill = NA)
  )+
  scale_x_discrete(labels = c("GSAKM", "SEM", "SEMK", "SKM"))
ggsave("metric/Plot_metric_20_50_2_4.png",plot=plot_metric_20_50_2_4)
stats_table_metric_20_50_2_4 <- results_20_50_2_4 %>%
  select(all_of(selected_20_50_2_4_metric)) %>%
  pivot_longer(
    everything(),
    names_to = "Variable",
    values_to = "Value"
  ) %>%
  group_by(Variable) %>%
  summarise(
    `Mean` = mean(Value, na.rm = TRUE),
    `SD` = sd(Value, na.rm = TRUE),
    .groups = "drop"
  )
write_csv(stats_table_metric_20_50_2_4, "metric/stats_table_metric_20_50_2_4.csv")


results_20_35_3_4<- read_csv("results_with_D=20,p=35,q=3,K=4.csv")
selected_20_35_3_4_metric <- c("best_SEM_metric", "best_SEMK_metric", "best_SKM_metric","best_metric")
df_long_20_35_3_4_metric <- results_20_35_3_4 %>%
  select(selected_20_35_3_4_metric) %>%
  pivot_longer(
    everything(),
    names_to = "Variable",
    values_to = "Value"
  )
plot_metric_20_35_3_4<-ggplot(df_long_20_35_3_4_metric, aes(x = Variable, y = Value)) +
  geom_boxplot(fill = "skyblue", alpha = 0.7) +
  labs(title = "D=20,p=35,q=3,K=4",
       x="Within-cluster sum of squares",
       y = "") +
  theme_minimal()+
  theme(
    plot.title = element_text(size = 40, face = "bold", hjust = 0.5),
    axis.title.x = element_text(size = 30),
    axis.title.y = element_text(size = 30),
    axis.text.x = element_text(size = 15),
    axis.text.y = element_text(size = 15),
    axis.line = element_line(color = "black"),
    panel.border = element_rect(color = "black", fill = NA)
  )+
  scale_x_discrete(labels = c("GSAKM", "SEM", "SEMK", "SKM"))
ggsave("metric/Plot_metric_20_35_3_4.png",plot=plot_metric_20_35_3_4)
stats_table_metric_20_35_3_4 <- results_20_35_3_4 %>%
  select(all_of(selected_20_35_3_4_metric)) %>%
  pivot_longer(
    everything(),
    names_to = "Variable",
    values_to = "Value"
  ) %>%
  group_by(Variable) %>%
  summarise(
    `Mean` = mean(Value, na.rm = TRUE),
    `SD` = sd(Value, na.rm = TRUE),
    .groups = "drop"
  )
write_csv(stats_table_metric_20_35_3_4, "metric/stats_table_metric_20_35_3_4.csv")


results_20_35_2_4<- read_csv("results_with_D=20,p=35,q=2,K=4.csv")
selected_20_35_2_4_metric <- c("best_SEM_metric", "best_SEMK_metric", "best_SKM_metric","best_metric")
df_long_20_35_2_4_metric <- results_20_35_2_4 %>%
  select(selected_20_35_2_4_metric) %>%
  pivot_longer(
    everything(),
    names_to = "Variable",
    values_to = "Value"
  )
plot_metric_20_35_2_4<-ggplot(df_long_20_35_2_4_metric, aes(x = Variable, y = Value)) +
  geom_boxplot(fill = "skyblue", alpha = 0.7) +
  labs(title = "D=20,p=35,q=2,K=4",
       x="Within-cluster sum of squares",
       y = "") +
  theme_minimal()+
  theme(
    plot.title = element_text(size = 40, face = "bold", hjust = 0.5),
    axis.title.x = element_text(size = 30),
    axis.title.y = element_text(size = 30),
    axis.text.x = element_text(size = 15),
    axis.text.y = element_text(size = 15),
    axis.line = element_line(color = "black"),
    panel.border = element_rect(color = "black", fill = NA)
  )+
  scale_x_discrete(labels = c("GSAKM", "SEM", "SEMK", "SKM"))
ggsave("metric/Plot_metric_20_35_2_4.png",plot=plot_metric_20_35_2_4)
stats_table_metric_20_35_2_4 <- results_20_35_2_4 %>%
  select(all_of(selected_20_35_2_4_metric)) %>%
  pivot_longer(
    everything(),
    names_to = "Variable",
    values_to = "Value"
  ) %>%
  group_by(Variable) %>%
  summarise(
    `Mean` = mean(Value, na.rm = TRUE),
    `SD` = sd(Value, na.rm = TRUE),
    .groups = "drop"
  )
write_csv(stats_table_metric_20_35_2_4, "metric/stats_table_metric_20_35_2_4.csv")

results_40_50_3_3<- read_csv("results_with_D=40,p=50,q=3,K=3.csv")
selected_40_50_3_3_metric <- c("best_SEM_metric", "best_SEMK_metric", "best_SKM_metric","best_metric")
df_long_40_50_3_3_metric <- results_40_50_3_3 %>%
  select(selected_40_50_3_3_metric) %>%
  pivot_longer(
    everything(),
    names_to = "Variable",
    values_to = "Value"
  )
plot_metric_40_50_3_3<-ggplot(df_long_40_50_3_3_metric, aes(x = Variable, y = Value)) +
  geom_boxplot(fill = "skyblue", alpha = 0.7) +
  labs(title = "D=40,p=50,q=3,K=3",
       x="Within-cluster sum of squares",
       y = "") +
  theme_minimal()+
  theme(
    plot.title = element_text(size = 40, face = "bold", hjust = 0.5),
    axis.title.x = element_text(size = 30),
    axis.title.y = element_text(size = 30),
    axis.text.x = element_text(size = 15),
    axis.text.y = element_text(size = 15),
    axis.line = element_line(color = "black"),
    panel.border = element_rect(color = "black", fill = NA)
  )+
  scale_x_discrete(labels = c("GSAKM", "SEM", "SEMK", "SKM"))
ggsave("metric/Plot_metric_40_50_3_3.png",plot=plot_metric_40_50_3_3)
stats_table_metric_40_50_3_3 <- results_40_50_3_3 %>%
  select(all_of(selected_40_50_3_3_metric)) %>%
  pivot_longer(
    everything(),
    names_to = "Variable",
    values_to = "Value"
  ) %>%
  group_by(Variable) %>%
  summarise(
    `Mean` = mean(Value, na.rm = TRUE),
    `SD` = sd(Value, na.rm = TRUE),
    .groups = "drop"
  )
write_csv(stats_table_metric_40_50_3_3, "metric/stats_table_metric_40_50_3_3.csv")


results_40_50_2_3<- read_csv("results_with_D=40,p=50,q=2,K=3.csv")
selected_40_50_2_3_metric <- c("best_SEM_metric", "best_SEMK_metric", "best_SKM_metric","best_metric")
df_long_40_50_2_3_metric <- results_40_50_2_3 %>%
  select(selected_40_50_2_3_metric) %>%
  pivot_longer(
    everything(),
    names_to = "Variable",
    values_to = "Value"
  )
plot_metric_40_50_2_3<-ggplot(df_long_40_50_2_3_metric, aes(x = Variable, y = Value)) +
  geom_boxplot(fill = "skyblue", alpha = 0.7) +
  labs(title = "D=40,p=50,q=2,K=3",
       x="Within-cluster sum of squares",
       y = "") +
  theme_minimal()+
  theme(
    plot.title = element_text(size = 40, face = "bold", hjust = 0.5),
    axis.title.x = element_text(size = 30),
    axis.title.y = element_text(size = 30),
    axis.text.x = element_text(size = 15),
    axis.text.y = element_text(size = 15),
    axis.line = element_line(color = "black"),
    panel.border = element_rect(color = "black", fill = NA)
  )+
  scale_x_discrete(labels = c("GSAKM", "SEM", "SEMK", "SKM"))
ggsave("metric/Plot_metric_40_50_2_3.png",plot=plot_metric_40_50_2_3)
stats_table_metric_40_50_2_3 <- results_40_50_2_3 %>%
  select(all_of(selected_40_50_2_3_metric)) %>%
  pivot_longer(
    everything(),
    names_to = "Variable",
    values_to = "Value"
  ) %>%
  group_by(Variable) %>%
  summarise(
    `Mean` = mean(Value, na.rm = TRUE),
    `SD` = sd(Value, na.rm = TRUE),
    .groups = "drop"
  )
write_csv(stats_table_metric_40_50_2_3, "metric/stats_table_metric_40_50_2_3.csv")


results_40_70_3_3<- read_csv("results_with_D=40,p=70,q=3,K=3.csv")
selected_40_70_3_3_metric <- c("best_SEM_metric", "best_SEMK_metric", "best_SKM_metric","best_metric")
df_long_40_70_3_3_metric <- results_40_70_3_3 %>%
  select(selected_40_70_3_3_metric) %>%
  pivot_longer(
    everything(),
    names_to = "Variable",
    values_to = "Value"
  )
plot_metric_40_70_3_3<-ggplot(df_long_40_70_3_3_metric, aes(x = Variable, y = Value)) +
  geom_boxplot(fill = "skyblue", alpha = 0.7) +
  labs(title = "D=40,p=70,q=3,K=3",
       x="Within-cluster sum of squares",
       y = "") +
  theme_minimal()+
  theme(
    plot.title = element_text(size = 40, face = "bold", hjust = 0.5),
    axis.title.x = element_text(size = 30),
    axis.title.y = element_text(size = 30),
    axis.text.x = element_text(size = 15),
    axis.text.y = element_text(size = 15),
    axis.line = element_line(color = "black"),
    panel.border = element_rect(color = "black", fill = NA)
  )+
  scale_x_discrete(labels = c("GSAKM", "SEM", "SEMK", "SKM"))
ggsave("metric/Plot_metric_40_70_3_3.png",plot=plot_metric_40_70_3_3)
stats_table_metric_40_70_3_3 <- results_40_70_3_3 %>%
  select(all_of(selected_40_70_3_3_metric)) %>%
  pivot_longer(
    everything(),
    names_to = "Variable",
    values_to = "Value"
  ) %>%
  group_by(Variable) %>%
  summarise(
    `Mean` = mean(Value, na.rm = TRUE),
    `SD` = sd(Value, na.rm = TRUE),
    .groups = "drop"
  )
write_csv(stats_table_metric_40_70_3_3, "metric/stats_table_metric_40_70_3_3.csv")


results_40_70_2_3<- read_csv("results_with_D=40,p=70,q=2,K=3.csv")
selected_40_70_2_3_metric <- c("best_SEM_metric", "best_SEMK_metric", "best_SKM_metric","best_metric")
df_long_40_70_2_3_metric <- results_40_70_2_3 %>%
  select(selected_40_70_2_3_metric) %>%
  pivot_longer(
    everything(),
    names_to = "Variable",
    values_to = "Value"
  )
plot_metric_40_70_2_3<-ggplot(df_long_40_70_2_3_metric, aes(x = Variable, y = Value)) +
  geom_boxplot(fill = "skyblue", alpha = 0.7) +
  labs(title = "D=40,p=70,q=2,K=3",
       x="Within-cluster sum of squares",
       y = "") +
  theme_minimal()+
  theme(
    plot.title = element_text(size = 40, face = "bold", hjust = 0.5),
    axis.title.x = element_text(size = 30),
    axis.title.y = element_text(size = 30),
    axis.text.x = element_text(size = 15),
    axis.text.y = element_text(size = 15),
    axis.line = element_line(color = "black"),
    panel.border = element_rect(color = "black", fill = NA)
  )+
  scale_x_discrete(labels = c("GSAKM", "SEM", "SEMK", "SKM"))
ggsave("metric/Plot_metric_40_70_2_3.png",plot=plot_metric_40_70_2_3)
stats_table_metric_40_70_2_3 <- results_40_70_2_3 %>%
  select(all_of(selected_40_70_2_3_metric)) %>%
  pivot_longer(
    everything(),
    names_to = "Variable",
    values_to = "Value"
  ) %>%
  group_by(Variable) %>%
  summarise(
    `Mean` = mean(Value, na.rm = TRUE),
    `SD` = sd(Value, na.rm = TRUE),
    .groups = "drop"
  )
write_csv(stats_table_metric_40_70_2_3, "metric/stats_table_metric_40_70_2_3.csv")


results_40_50_3_4<- read_csv("results_with_D=40,p=50,q=3,K=4.csv")
selected_40_50_3_4_metric <- c("best_SEM_metric", "best_SEMK_metric", "best_SKM_metric","best_metric")
df_long_40_50_3_4_metric <- results_40_50_3_4 %>%
  select(selected_40_50_3_4_metric) %>%
  pivot_longer(
    everything(),
    names_to = "Variable",
    values_to = "Value"
  )
plot_metric_40_50_3_4<-ggplot(df_long_40_50_3_4_metric, aes(x = Variable, y = Value)) +
  geom_boxplot(fill = "skyblue", alpha = 0.7) +
  labs(title = "D=40,p=50,q=3,K=4",
       x="Within-cluster sum of squares",
       y = "") +
  theme_minimal()+
  theme(
    plot.title = element_text(size = 40, face = "bold", hjust = 0.5),
    axis.title.x = element_text(size = 30),
    axis.title.y = element_text(size = 30),
    axis.text.x = element_text(size = 15),
    axis.text.y = element_text(size = 15),
    axis.line = element_line(color = "black"),
    panel.border = element_rect(color = "black", fill = NA)
  )+
  scale_x_discrete(labels = c("GSAKM", "SEM", "SEMK", "SKM"))
ggsave("metric/Plot_metric_40_50_3_4.png",plot=plot_metric_40_50_3_4)
stats_table_metric_40_50_3_4 <- results_40_50_3_4 %>%
  select(all_of(selected_40_50_3_4_metric)) %>%
  pivot_longer(
    everything(),
    names_to = "Variable",
    values_to = "Value"
  ) %>%
  group_by(Variable) %>%
  summarise(
    `Mean` = mean(Value, na.rm = TRUE),
    `SD` = sd(Value, na.rm = TRUE),
    .groups = "drop"
  )
write_csv(stats_table_metric_40_50_3_4, "metric/stats_table_metric_40_50_3_4.csv")


results_40_50_2_4<- read_csv("results_with_D=40,p=50,q=2,K=4.csv")
selected_40_50_2_4_metric <- c("best_SEM_metric", "best_SEMK_metric", "best_SKM_metric","best_metric")
df_long_40_50_2_4_metric <- results_40_50_2_4 %>%
  select(selected_40_50_2_4_metric) %>%
  pivot_longer(
    everything(),
    names_to = "Variable",
    values_to = "Value"
  )
plot_metric_40_50_2_4<-ggplot(df_long_40_50_2_4_metric, aes(x = Variable, y = Value)) +
  geom_boxplot(fill = "skyblue", alpha = 0.7) +
  labs(title = "D=40,p=50,q=2,K=4",
       x="Within-cluster sum of squares",
       y = "") +
  theme_minimal()+
  theme(
    plot.title = element_text(size = 40, face = "bold", hjust = 0.5),
    axis.title.x = element_text(size = 30),
    axis.title.y = element_text(size = 30),
    axis.text.x = element_text(size = 15),
    axis.text.y = element_text(size = 15),
    axis.line = element_line(color = "black"),
    panel.border = element_rect(color = "black", fill = NA)
  )+
  scale_x_discrete(labels = c("GSAKM", "SEM", "SEMK", "SKM"))
ggsave("metric/Plot_metric_40_50_2_4.png",plot=plot_metric_40_50_2_4)
stats_table_metric_40_50_2_4 <- results_40_50_2_4 %>%
  select(all_of(selected_40_50_2_4_metric)) %>%
  pivot_longer(
    everything(),
    names_to = "Variable",
    values_to = "Value"
  ) %>%
  group_by(Variable) %>%
  summarise(
    `Mean` = mean(Value, na.rm = TRUE),
    `SD` = sd(Value, na.rm = TRUE),
    .groups = "drop"
  )
write_csv(stats_table_metric_40_50_2_4, "metric/stats_table_metric_40_50_2_4.csv")


results_40_35_3_4<- read_csv("results_with_D=40,p=35,q=3,K=4.csv")
selected_40_35_3_4_metric <- c("best_SEM_metric", "best_SEMK_metric", "best_SKM_metric","best_metric")
df_long_40_35_3_4_metric <- results_40_35_3_4 %>%
  select(selected_40_35_3_4_metric) %>%
  pivot_longer(
    everything(),
    names_to = "Variable",
    values_to = "Value"
  )
plot_metric_40_35_3_4<-ggplot(df_long_40_35_3_4_metric, aes(x = Variable, y = Value)) +
  geom_boxplot(fill = "skyblue", alpha = 0.7) +
  labs(title = "D=40,p=35,q=3,K=4",
       x="Within-cluster sum of squares",
       y = "") +
  theme_minimal()+
  theme(
    plot.title = element_text(size = 40, face = "bold", hjust = 0.5),
    axis.title.x = element_text(size = 30),
    axis.title.y = element_text(size = 30),
    axis.text.x = element_text(size = 15),
    axis.text.y = element_text(size = 15),
    axis.line = element_line(color = "black"),
    panel.border = element_rect(color = "black", fill = NA)
  )+
  scale_x_discrete(labels = c("GSAKM", "SEM", "SEMK", "SKM"))
ggsave("metric/Plot_metric_40_35_3_4.png",plot=plot_metric_40_35_3_4)
stats_table_metric_40_35_3_4 <- results_40_35_3_4 %>%
  select(all_of(selected_40_35_3_4_metric)) %>%
  pivot_longer(
    everything(),
    names_to = "Variable",
    values_to = "Value"
  ) %>%
  group_by(Variable) %>%
  summarise(
    `Mean` = mean(Value, na.rm = TRUE),
    `SD` = sd(Value, na.rm = TRUE),
    .groups = "drop"
  )
write_csv(stats_table_metric_40_35_3_4, "metric/stats_table_metric_40_35_3_4.csv")


results_40_35_2_4<- read_csv("results_with_D=40,p=35,q=2,K=4.csv")
selected_40_35_2_4_metric <- c("best_SEM_metric", "best_SEMK_metric", "best_SKM_metric","best_metric")
df_long_40_35_2_4_metric <- results_40_35_2_4 %>%
  select(selected_40_35_2_4_metric) %>%
  pivot_longer(
    everything(),
    names_to = "Variable",
    values_to = "Value"
  )
plot_metric_40_35_2_4<-ggplot(df_long_40_35_2_4_metric, aes(x = Variable, y = Value)) +
  geom_boxplot(fill = "skyblue", alpha = 0.7) +
  labs(title = "D=40,p=35,q=2,K=4",
       x="Within-cluster sum of squares",
       y = "") +
  theme_minimal()+
  theme(
    plot.title = element_text(size = 40, face = "bold", hjust = 0.5),
    axis.title.x = element_text(size = 30),
    axis.title.y = element_text(size = 30),
    axis.text.x = element_text(size = 15),
    axis.text.y = element_text(size = 15),
    axis.line = element_line(color = "black"),
    panel.border = element_rect(color = "black", fill = NA)
  )+
  scale_x_discrete(labels = c("GSAKM", "SEM", "SEMK", "SKM"))
ggsave("metric/Plot_metric_40_35_2_4.png",plot=plot_metric_40_35_2_4)
stats_table_metric_40_35_2_4 <- results_40_35_2_4 %>%
  select(all_of(selected_40_35_2_4_metric)) %>%
  pivot_longer(
    everything(),
    names_to = "Variable",
    values_to = "Value"
  ) %>%
  group_by(Variable) %>%
  summarise(
    `Mean` = mean(Value, na.rm = TRUE),
    `SD` = sd(Value, na.rm = TRUE),
    .groups = "drop"
  )
write_csv(stats_table_metric_40_35_2_4, "metric/stats_table_metric_40_35_2_4.csv")