library(MASS)
library(igraph)
library(clue)
library(ggplot2)
library(foreach)
library(doParallel)
library(digest)
RNGkind("L'Ecuyer-CMRG")
set.seed(285714) #The seeds we use
generate_orthogonal_matrix = function(n) {
  A = matrix(rnorm(n * n), nrow = n, ncol = n)
  qr_result = qr(A)
  Q = qr.Q(qr_result)
  
  return(Q)
}


D=40
p=35
q=2
k=4 #By modifying these parameter group,we can obtain the results under different parameter conditions.

n=500
kk=k
sigma_1=1
sigma_2=1
cluster_parameter=matrix(0,nrow=p*q,ncol=k)
for(i in 1:k){
  cluster_parameter[i,i]=1
}
cluster_parameter=(D/sqrt(2))*(generate_orthogonal_matrix(p*q)%*%cluster_parameter)
random_column <-rnorm(p*q,mean=0,sd=2*D/sqrt(p*q))
repeated_columns <- matrix(rep(random_column, k), nrow = p*q, ncol = k, byrow = FALSE)
cluster_parameter=cluster_parameter+repeated_columns
Sigma_2=matrix(rep(0,p*p),nrow=p,ncol=p)
for(i in 1:p){
  for(j in 1:p){
    Sigma_2[i,j]=(0.3)^{abs(i-j)}
  }
}
eigen_S=eigen(Sigma_2)
Sigma=eigen_S$vector%*%diag(sqrt(eigen_S$values))%*%t(eigen_S$vector)


smart_combine = function(agg, ...) {
  new_results = list(...)
  for (result in new_results) {
    if (is.null(result)) next
    if (result$metric < agg$best_metric) {
      agg$best_metric = result$metric
      agg$best_matrix = result$matrix
      agg$best_accuracy= result$accuracy
      agg$best_test_metric=result$test_metric
      agg$best_test_accuracy=result$test_accuracy
    }
    if (result$SKM_metric < agg$best_SKM_metric) {
      agg$best_SKM_metric = result$SKM_metric
      agg$best_SKM_matrix = result$SKM_matrix
      agg$best_SKM_accuracy= result$SKM_accuracy
      agg$best_SKM_test_metric=result$SKM_test_metric
      agg$best_SKM_test_accuracy=result$SKM_test_accuracy
    }
    if (result$SEMK_metric < agg$best_SEMK_metric) {
      agg$best_SEMK_metric = result$SEMK_metric
      agg$best_SEMK_matrix = result$SEMK_matrix
      agg$best_SEMK_accuracy= result$SEMK_accuracy
      agg$best_SEMK_test_metric=result$SEMK_test_metric
      agg$best_SEMK_test_accuracy=result$SEMK_test_accuracy
    }
    if (result$SEM_metric < agg$best_SEM_metric) {
      agg$best_SEM_metric = result$SEM_metric
      agg$best_SEM_matrix = result$SEM_matrix
      agg$best_SEM_accuracy= result$SEM_accuracy
      agg$best_SEM_test_metric=result$SEM_test_metric
      agg$best_SEM_test_accuracy=result$SEM_test_accuracy
    }
  }
  
  return(agg)
}
initial_agg = list(
  best_SEM_metric=Inf,
  best_SEM_matrix=NULL,
  best_SEM_accuracy= NULL,
  best_SEM_test_metric=Inf,
  best_SEM_test_accuracy=NULL,
  best_SEMK_metric=Inf,
  best_SEMK_matrix=NULL,
  best_SEMK_accuracy= NULL,
  best_SEMK_test_metric=Inf,
  best_SEMK_test_accuracy=NULL,
  best_SKM_metric=Inf,
  best_SKM_matrix=NULL,
  best_SKM_accuracy= NULL,
  best_SKM_test_metric=Inf,
  best_SKM_test_accuracy=NULL,
  best_metric = Inf,
  best_matrix = NULL,
  best_accuracy= NULL,
  best_test_metric=Inf,
  best_test_accuracy=NULL
)
total_iterations=10
cl = makeCluster(10) 
registerDoParallel(cl)


#这里是重复实验部分
final_result_list <- list()
for(Ti in 1:100){
  #生成训练集
  cluster_label=matrix(0,nrow=k,ncol=n)
  X=matrix(rnorm(n*p,mean=0,sd=sigma_1),nrow=n,ncol=p)
  X=X%*%Sigma
  Y=matrix(rnorm(n*q,mean=0,sd=sigma_2),nrow=n,ncol=q)
  cluster=sample(1:k, n, replace = TRUE)
  for(i in 1:n){
    cluster_label[cluster[i],i]=1
  }
  Beta=cluster_parameter%*%cluster_label
  for(i in 1:n){
    BB=matrix(Beta[ ,i],nrow=p,ncol=q)
    Y[i, ]=X[i, ]%*%BB+Y[i, ]
  }
  #生成测试集
  cluster_label_test=matrix(0,nrow=k,ncol=n)
  X_test=matrix(rnorm(n*p,mean=0,sd=sigma_1),nrow=n,ncol=p)
  X_test=X_test%*%Sigma
  Y_test=matrix(rnorm(n*q,mean=0,sd=sigma_2),nrow=n,ncol=q)
  cluster_test=sample(1:k, n, replace = TRUE)
  for(i in 1:n){
    cluster_label_test[cluster_test[i],i]=1
  }
  Beta_test=cluster_parameter%*%cluster_label_test
  for(i in 1:n){
    BB_test=matrix(Beta_test[ ,i],nrow=p,ncol=q)
    Y_test[i, ]=X_test[i, ]%*%BB_test+Y_test[i, ]
  }
  
  #下面是分析部分
  random_strings <- replicate(total_iterations, {
    paste(sample(letters, 10, replace = TRUE), collapse = "")
  })
  seeds <- sapply(random_strings, digest::digest2int)
  my_k_means_center=matrix(0,nrow=p*q,ncol=kk)
  my_k_means_cluster=rep(0,n)
  results = foreach(repe = 1:total_iterations, .combine =smart_combine , 
                    .init = initial_agg, .multicombine = TRUE,
                    .packages = c("MASS","clue")) %dopar%{
                      set.seed(seeds[repe])
                      flag=n
                      #K-means++初始化
                      center_i=matrix(0,nrow=p*q,ncol=kk)
                      mynote=rep(1,n)
                      rsc=sample(1:n,1) #random sample center
                      mynote[rsc]=0
                      center_i[, 1]=(X[rsc,] %*% t(Y[rsc,]))/sum(X[rsc,]^2)
                      if(kk>=2){
                        for(ik in 2:kk){
                          dist=matrix(0,nrow=n,ncol=ik-1)
                          for (jk in 1:(ik-1)) {
                            B_j = matrix(center_i[, jk], nrow = p, ncol = q)
                            Y_pred = X %*% B_j
                            dist[, jk] = rowSums((Y - Y_pred)^2)
                          }
                          mindist = apply(dist, 1, min)*mynote
                          rsc=sample(1:n,1,prob=mindist/sum(mindist))
                          center_i[, ik]=(X[rsc,] %*% t(Y[rsc,]))/sum(X[rsc,]^2)
                          mynote[rsc]=0
                        }
                      }
                      cluster_i=rep(0,n)
                      epsilon_i=matrix(0,nrow=n,ncol=kk)
                      for (j in 1:kk) {
                        B_j = matrix(center_i[, j], nrow = p, ncol = q)
                        Y_pred = X %*% B_j
                        epsilon_i[, j] = rowSums((Y - Y_pred)^2)
                      }
                      min_epsilon_i = apply(epsilon_i, 1, min)
                      myresi_i=sum(min_epsilon_i)
                      #普通EM算法
                      myresi=myresi_i
                      SEM_center=center_i
                      SEM_cluster=cluster_i
                      SEM_pi=rep(1/kk,kk)
                      SEM_cov=(myresi/n*q)*diag(q)
                      SEM_cov_kk <- matrix(rep(as.vector(SEM_cov), kk), ncol = kk)
                      iter=0
                      flag=n
                      countzero=0
                      while(countzero<=5){
                        flag=n
                        #E步
                        XB_list <- lapply(1:kk, function(j) {
                          B_j <- matrix(SEM_center[, j], nrow = p, ncol = q)
                          X %*% B_j
                        })
                        d2 <- matrix(0, n, kk)
                        
                        for (j in 1:kk) {
                          SEM_inv_cov <- ginv(matrix(SEM_cov_kk[,j],q,q)+diag(1e-6,q))
                          resid <- Y - XB_list[[j]]
                          d2[, j] <- rowSums(resid %*% SEM_inv_cov * resid)
                        }
                        SEM_log_gamma_raw <- log(matrix(SEM_pi, n, kk, byrow = TRUE)) - 0.5 * d2+0.5*log(det(SEM_inv_cov)/(2*pi)^q)
                        SEM_gamma_raw <- exp(SEM_log_gamma_raw- apply(SEM_log_gamma_raw, 1, max))
                        SEM_gamma <- SEM_gamma_raw / rowSums(SEM_gamma_raw)
                        #M步
                        
                        SEM_pi=colSums(SEM_gamma)/n
                        SEM_epsilon = matrix(Inf, nrow = n, ncol = kk)
                        for(j in 1:kk){
                          X_j=X*sqrt(SEM_gamma[,j])
                          Y_j=Y*sqrt(SEM_gamma[,j])
                          B_j=ginv(crossprod(X_j))%*%crossprod(X_j,Y_j)
                          SEM_center[, j]=B_j
                          resident_j=Y_j-X_j%*%B_j
                          SEM_cov_j=crossprod(resident_j)/sum(SEM_gamma[,j])
                          SEM_cov_kk[,j]=SEM_cov_j
                          ep_resident_j=Y-X%*%B_j
                          SEM_epsilon[,j]=rowSums(ep_resident_j^{2})
                        }
                        min_SEM_epsilon=apply(SEM_epsilon,1,min)
                        SEM_resi=sum(min_SEM_epsilon)
                        #收敛判断
                        zi = apply(SEM_gamma, 1, which.max)
                        for(i in 1:n){
                          if(SEM_cluster[i]!=zi[i]){
                            SEM_cluster[i]=zi[i]
                          }else{
                            flag=flag-1
                          } 
                        }
                        if(flag>2){
                          countzero=0
                        }else{
                          countzero=countzero+1
                        }
                        iter=iter+1
                      }
                      SEM_match_matrix=matrix(0,nrow=k,ncol=kk)
                      for(i in 1:k){
                        for(j in 1:kk){
                          gapvec=SEM_center[,j]-cluster_parameter[,i]
                          SEM_match_matrix[i,j]=sqrt(sum(gapvec^2))
                        }
                      }
                      SEM_match_result=solve_LSAP(SEM_match_matrix)
                      
                      SEM_maxF=0
                      for(i in 1:k){
                        if(SEM_match_matrix[i,SEM_match_result[i]]>SEM_maxF){
                          SEM_maxF=SEM_match_matrix[i,SEM_match_result[i]]
                        }
                      }
                      SEM_real_cluster=SEM_match_result[cluster]
                      SEM_Accuracy=sum(SEM_real_cluster==SEM_cluster)/n
                      #测试集
                      XB_list_test<- lapply(1:kk, function(j) {
                        B_j <- matrix(SEM_center[, j], nrow = p, ncol = q)
                        X_test %*% B_j
                      })
                      d2_test <- matrix(0, n, kk)
                      
                      for (j in 1:kk) {
                        SEM_inv_cov <- ginv(matrix(SEM_cov_kk[,j],q,q)+diag(1e-6,q))
                        resid <- Y_test - XB_list_test[[j]]
                        d2_test[, j] <- rowSums(resid %*% SEM_inv_cov * resid)
                      }
                      SEM_log_gamma_raw_test <- log(matrix(SEM_pi, n, kk, byrow = TRUE)) - 0.5 * d2_test+0.5*log(det(SEM_inv_cov)/(2*pi)^q)
                      SEM_gamma_raw_test <- exp(SEM_log_gamma_raw_test-apply(SEM_log_gamma_raw_test, 1, max))
                      SEM_gamma_test <- SEM_gamma_raw_test / rowSums(SEM_gamma_raw_test)
                      SEM_cluster_test=apply(SEM_gamma_test, 1, which.max)
                      SEM_epsilon_test=matrix(Inf,nrow=n,ncol=kk)
                      for(j in 1:kk){
                        B_j=matrix(SEM_center[, j], nrow = p, ncol = q)
                        ep_resident_test_j=Y_test-X_test%*%B_j
                        SEM_epsilon_test[,j]=rowSums(ep_resident_test_j^{2})
                      }
                      min_SEM_epsilon_test=apply(SEM_epsilon_test,1,min)
                      SEM_resi_test=sum(min_SEM_epsilon_test)
                      SEM_real_cluster_test=SEM_match_result[cluster_test]
                      SEM_Accuracy_test=sum(SEM_real_cluster_test==SEM_cluster_test)/n
                      #EM算法，误差标准差已知
                      myresi=myresi_i
                      SEMK_center=center_i
                      SEMK_cluster=cluster_i
                      SEMK_pi=rep(1/kk,kk)
                      SEMK_cov=sigma_1*diag(q)
                      iter=0
                      flag=n
                      countzero=0
                      while(countzero<=5){
                        flag=n
                        #E步
                        XB_list <- lapply(1:kk, function(j) {
                          B_j <- matrix(SEMK_center[, j], nrow = p, ncol = q)
                          X %*% B_j
                        })
                        d2 <- matrix(0, n, kk)
                        
                        for (j in 1:kk) {
                          SEMK_inv_cov <- solve(SEMK_cov)
                          resid <- Y - XB_list[[j]]
                          d2[, j] <- rowSums(resid %*% SEMK_inv_cov * resid)
                        }
                        SEMK_log_gamma_raw <- log(matrix(SEMK_pi, n, kk, byrow = TRUE)) - 0.5 * d2+0.5*log(det(SEMK_inv_cov)/(2*pi)^q)
                        SEMK_gamma_raw <- exp(SEMK_log_gamma_raw- apply(SEMK_log_gamma_raw, 1, max))
                        SEMK_gamma <- SEMK_gamma_raw / rowSums(SEMK_gamma_raw)
                        #M步
                        
                        SEMK_pi=colSums(SEMK_gamma)/n
                        SEMK_epsilon = matrix(Inf, nrow = n, ncol = kk)
                        for(j in 1:kk){
                          X_j=X*sqrt(SEMK_gamma[,j])
                          Y_j=Y*sqrt(SEMK_gamma[,j])
                          B_j=ginv(crossprod(X_j))%*%crossprod(X_j,Y_j)
                          SEMK_center[, j]=B_j
                          ep_resident_j=Y-X%*%B_j
                          SEMK_epsilon[,j]=rowSums(ep_resident_j^{2})
                        }
                        min_SEMK_epsilon=apply(SEMK_epsilon,1,min)
                        SEMK_resi=sum(min_SEMK_epsilon)
                        #收敛判断
                        zi = apply(SEMK_gamma, 1, which.max)
                        for(i in 1:n){
                          if(SEMK_cluster[i]!=zi[i]){
                            SEMK_cluster[i]=zi[i]
                          }else{
                            flag=flag-1
                          } 
                        }
                        if(flag>2){
                          countzero=0
                        }else{
                          countzero=countzero+1
                        }
                        iter=iter+1
                      }
                      SEMK_match_matrix=matrix(0,nrow=k,ncol=kk)
                      for(i in 1:k){
                        for(j in 1:kk){
                          gapvec=SEMK_center[,j]-cluster_parameter[,i]
                          SEMK_match_matrix[i,j]=sqrt(sum(gapvec^2))
                        }
                      }
                      SEMK_match_result=solve_LSAP(SEMK_match_matrix)
                      
                      SEMK_maxF=0
                      for(i in 1:k){
                        if(SEMK_match_matrix[i,SEMK_match_result[i]]>SEMK_maxF){
                          SEMK_maxF=SEMK_match_matrix[i,SEMK_match_result[i]]
                        }
                      }
                      SEMK_real_cluster=SEMK_match_result[cluster]
                      SEMK_Accuracy=sum(SEMK_real_cluster==SEMK_cluster)/n
                      #测试集
                      XB_list_test<- lapply(1:kk, function(j) {
                        B_j <- matrix(SEMK_center[, j], nrow = p, ncol = q)
                        X_test %*% B_j
                      })
                      d2_test <- matrix(0, n, kk)
                      
                      for (j in 1:kk) {
                        SEMK_inv_cov <- solve(SEMK_cov)
                        resid <- Y_test - XB_list_test[[j]]
                        d2_test[, j] <- rowSums(resid %*% SEMK_inv_cov * resid)
                      }
                      SEMK_log_gamma_raw_test <- log(matrix(SEMK_pi, n, kk, byrow = TRUE)) - 0.5 * d2_test+0.5*log(det(SEMK_inv_cov)/(2*pi)^q)
                      SEMK_gamma_raw_test <- exp(SEMK_log_gamma_raw_test-apply(SEMK_log_gamma_raw_test, 1, max))
                      SEMK_gamma_test <- SEMK_gamma_raw_test / rowSums(SEMK_gamma_raw_test)
                      SEMK_cluster_test=apply(SEMK_gamma_test, 1, which.max)
                      SEMK_epsilon_test=matrix(Inf, nrow = n, ncol = kk)
                      for(j in 1:kk){
                        B_j=matrix(SEMK_center[, j], nrow = p, ncol = q)
                        ep_resident_test_j=Y_test-X_test%*%B_j
                        SEMK_epsilon_test[,j]=rowSums(ep_resident_test_j^{2})
                      }
                      min_SEMK_epsilon_test=apply(SEMK_epsilon_test,1,min)
                      SEMK_resi_test=sum(min_SEMK_epsilon_test)
                      SEMK_real_cluster_test=SEMK_match_result[cluster_test]
                      SEMK_Accuracy_test=sum(SEMK_real_cluster_test==SEMK_cluster_test)/n
                      #普通K-means
                      SKM_myresi=myresi_i
                      SKM_k_means_center=center_i
                      SKM_k_means_cluster=cluster_i
                      SKM_min_epsilon=min_epsilon_i
                      iter=0
                      flag=n
                      while(flag>0){
                        flag=n
                        mynote=rep(1,n)
                        for(ik in 1:kk){
                          if(sum(SKM_k_means_cluster==ik)>=2){
                            Xk=X[SKM_k_means_cluster==ik, ]
                            Yk=Y[SKM_k_means_cluster==ik, ]
                          }else if(sum(SKM_k_means_cluster==ik)==1){
                            Xk=t(X[SKM_k_means_cluster==ik, ])
                            Yk=t(Y[SKM_k_means_cluster==ik, ])
                            rsc=which(SKM_k_means_cluster==ik)
                            mynote[rsc]=0
                          }else{
                            mindist=SKM_min_epsilon*mynote
                            rsc=sample(1:n,1,prob=mindist/sum(mindist))
                            SKM_k_means_cluster[rsc]=ik
                            mynote[rsc]=0
                            Xk=t(X[SKM_k_means_cluster==ik, ])
                            Yk=t(Y[SKM_k_means_cluster==ik, ])
                          }
                          crossprod_Xk = crossprod(Xk)
                          B=ginv(crossprod_Xk) %*% crossprod(Xk,Yk)
                          SKM_k_means_center[,ik]=B
                        }
                        SKM_epsilon = matrix(Inf, nrow = n, ncol = kk)
                        for (j in 1:kk) {
                          B_j = matrix(SKM_k_means_center[, j], nrow = p, ncol = q)
                          Y_pred = X %*% B_j
                          SKM_epsilon[, j] = rowSums((Y - Y_pred)^2)
                        }
                        SKM_min_epsilon = apply(SKM_epsilon, 1, min)
                        SKM_resi=sum(SKM_min_epsilon)
                        SKM_whichmin_epsilon=apply(SKM_epsilon, 1, which.min)
                        for(i in 1:n){
                          if(SKM_k_means_cluster[i]!=SKM_whichmin_epsilon[i]){
                            SKM_k_means_cluster[i]=SKM_whichmin_epsilon[i]
                          }else{
                            flag=flag-1
                          }
                        }
                        iter=iter+1
                      }
                      SKM_match_matrix=matrix(0,nrow=k,ncol=kk)
                      for(i in 1:k){
                        for(j in 1:kk){
                          gapvec=SKM_k_means_center[,j]-cluster_parameter[,i]
                          SKM_match_matrix[i,j]=sqrt(sum(gapvec^2))
                        }
                      }
                      SKM_match_result=solve_LSAP(SKM_match_matrix)
                      
                      SKM_maxF=0
                      for(i in 1:k){
                        if(SKM_match_matrix[i,SKM_match_result[i]]>SKM_maxF){
                          SKM_maxF=SKM_match_matrix[i,SKM_match_result[i]]
                        }
                      }
                      SKM_real_cluster=SKM_match_result[cluster]
                      SKM_Accuracy=sum(SKM_real_cluster==SKM_k_means_cluster)/n
                      #测试集
                      SKM_epsilon_test=matrix(Inf, nrow = n, ncol = kk)
                      for (j in 1:kk) {
                        B_j = matrix(SKM_k_means_center[, j], nrow = p, ncol = q)
                        Y_pred_test = X_test%*% B_j
                        SKM_epsilon_test[, j] = rowSums((Y_test - Y_pred_test)^2)
                      }
                      SKM_min_epsilon_test = apply(SKM_epsilon_test, 1, min)
                      SKM_resi_test=sum(SKM_min_epsilon_test)
                      SKM_cluster_test=apply(SKM_epsilon_test, 1, which.min)
                      SKM_real_cluster_test=SKM_match_result[cluster_test]
                      SKM_Accuracy_test=sum(SKM_real_cluster_test==SKM_cluster_test)/n
                      #迭代过程
                      myresi=myresi_i
                      k_means_center=center_i
                      k_means_cluster=cluster_i
                      iep=1
                      kapa=0.01
                      countzero=0
                      iter=0
                      while(countzero<=10 & iter<5000){
                        Temperature=kk*myresi/(q*n-q*p*kk)
                        flag=n
                        ep=iep/(log(exp(4)+0.5*iter)-3)^{0.99}
                        for(ik in 1:kk){
                          if(sum(k_means_cluster==ik)>=2){
                            Xk=X[k_means_cluster==ik, ]
                            Yk=Y[k_means_cluster==ik, ]
                          }else if(sum(k_means_cluster==ik)==1){
                            Xk=t(X[k_means_cluster==ik, ])
                            Yk=t(Y[k_means_cluster==ik, ])
                          }else{
                            Xk=t(rep(0,p))
                            Yk=t(rep(0,q))
                          }
                          crossprod_Xk = crossprod(Xk)  # Xk'Xk
                          reg_matrix = crossprod_Xk + ep * Temperature * kapa * diag(p)
                          Sigma_B_2 = solve(reg_matrix)  
                          B = Sigma_B_2 %*% crossprod(Xk, Yk)
                          R = chol(Sigma_B_2)
                          random_mat = matrix(rnorm(p * q), p, q)
                          B = B + sqrt(ep * Temperature) * crossprod(R, random_mat)
                          k_means_center[, ik] = B
                        }
                        epsilon = matrix(Inf, nrow = n, ncol = kk)
                        for (j in 1:kk) {
                          B_j = matrix(k_means_center[, j], nrow = p, ncol = q)
                          Y_pred = X %*% B_j
                          epsilon[, j] = rowSums((Y - Y_pred)^2)
                        }
                        min_epsilon = apply(epsilon, 1, min)
                        resi=sum(min_epsilon)
                        temp_factor = (ep * Temperature)/2
                        for (i in 1:n) {
                          zvec = exp(-(epsilon[i, ] - min_epsilon[i]) / temp_factor)
                          prob = zvec / sum(zvec)
                          zi = sample(1:kk, 1, prob = prob)
                          if(k_means_cluster[i]!=zi){
                            k_means_cluster[i]=zi
                          }else{
                            flag=flag-1
                          }
                        }
                        if(resi<myresi){
                          myresi=resi
                        }
                        if(flag>0){
                          countzero=0
                        }else{
                          countzero=countzero+1
                        }
                        iter=iter+1
                        #print(c(Ti,flag,resi,iter,repe,countzero,ep))
                      }
                      #普通K-means抛光
                      iter=0
                      flag=n
                      while(flag>0){
                        flag=n
                        mynote=rep(1,n)
                        for(ik in 1:kk){
                          if(sum(k_means_cluster==ik)>=2){
                            Xk=X[k_means_cluster==ik, ]
                            Yk=Y[k_means_cluster==ik, ]
                          }else if(sum(k_means_cluster==ik)==1){
                            Xk=t(X[k_means_cluster==ik, ])
                            Yk=t(Y[k_means_cluster==ik, ])
                            rsc=which(k_means_cluster==ik)
                            mynote[rsc]=0
                          }else{
                            mindist_polish=min_epsilon*mynote
                            rsc=sample(1:n,1,prob=mindist_polish/sum(mindist_polish))
                            k_means_cluster[rsc]=ik
                            mynote[rsc]=0
                            Xk=t(X[k_means_cluster==ik, ])
                            Yk=t(Y[k_means_cluster==ik, ])
                          }
                          crossprod_Xk = crossprod(Xk)
                          B=ginv(crossprod_Xk) %*% crossprod(Xk,Yk)
                          k_means_center[,ik]=B
                        }
                        epsilon = matrix(Inf, nrow = n, ncol = kk)
                        for (j in 1:kk) {
                          B_j = matrix(k_means_center[, j], nrow = p, ncol = q)
                          Y_pred = X %*% B_j
                          epsilon[, j] = rowSums((Y - Y_pred)^2)
                        }
                        min_epsilon = apply(epsilon, 1, min)
                        resi=sum(min_epsilon)
                        whichmin_epsilon=apply(epsilon, 1, which.min)
                        for(i in 1:n){
                          if(k_means_cluster[i]!=whichmin_epsilon[i]){
                            k_means_cluster[i]=whichmin_epsilon[i]
                          }else{
                            flag=flag-1
                          }
                        }
                        iter=iter+1
                      }
                      match_matrix=matrix(0,nrow=k,ncol=kk)
                      for(i in 1:k){
                        for(j in 1:kk){
                          gapvec=k_means_center[,j]-cluster_parameter[,i]
                          match_matrix[i,j]=sqrt(sum(gapvec^2))
                        }
                      }
                      match_result=solve_LSAP(match_matrix)
                      
                      maxF=0
                      for(i in 1:k){
                        if(match_matrix[i,match_result[i]]>maxF){
                          maxF=match_matrix[i,match_result[i]]
                        }
                      }
                      real_cluster=match_result[cluster]
                      Accuracy=sum(real_cluster==k_means_cluster)/n
                      #测试集
                      epsilon_test=matrix(Inf, nrow = n, ncol = kk)
                      for (j in 1:kk) {
                        B_j = matrix(k_means_center[, j], nrow = p, ncol = q)
                        Y_pred_test = X_test%*% B_j
                        epsilon_test[, j] = rowSums((Y_test - Y_pred_test)^2)
                      }
                      min_epsilon_test = apply(epsilon_test, 1, min)
                      resi_test=sum(min_epsilon_test)
                      k_means_cluster_test=apply(epsilon_test, 1, which.min)
                      real_cluster_test=match_result[cluster_test]
                      Accuracy_test=sum(real_cluster_test==k_means_cluster_test)/n
                      #总结部分
                      result_list=list(
                        SEM_metric = SEM_resi,
                        SEM_matrix = SEM_maxF,
                        SEM_accuracy=SEM_Accuracy,
                        SEM_test_metric=SEM_resi_test,
                        SEM_test_accuracy=SEM_Accuracy_test,
                        SEMK_metric = SEMK_resi,
                        SEMK_matrix = SEMK_maxF,
                        SEMK_accuracy=SEMK_Accuracy,
                        SEMK_test_metric=SEMK_resi_test,
                        SEMK_test_accuracy=SEMK_Accuracy_test,
                        SKM_metric = SKM_resi,
                        SKM_matrix = SKM_maxF,
                        SKM_accuracy=SKM_Accuracy,
                        SKM_test_metric=SKM_resi_test,
                        SKM_test_accuracy=SKM_Accuracy_test,
                        metric = resi,
                        matrix = maxF,
                        accuracy=Accuracy,
                        test_metric=resi_test,
                        test_accuracy=Accuracy_test
                      )
                    }
  print(Ti)
  final_result_list[[Ti]]=as.data.frame(results)
  
}
result_dataframe <- do.call(rbind, final_result_list)
stopCluster(cl)

csv_filename <- paste0("results_with","_D=",D,",p=",p,",q=",q,",K=",k, ".csv")
#rdata_filename <- paste0("results_with","_D=",D,",p=",p,",q=",q,",K=",k,".RData")
write.csv(result_dataframe, file = csv_filename, row.names = FALSE)
#save(result_dataframe, file = rdata_filename)





