## Learning from conflicting data with hidden contexts

The PyTorch implementation for the LEAF algorithm on regression and Fashion Product Images classification is provided here.

### Dependency
Python3 and some basic libraries are needed:  
- torch 1.7.1
- torchvision
- numpy
- matplotlib
- PIL
- skimage

### Regression
Hyperparameters on the dataset and the algorithm are listed at the beginning of the code.
The code itself is straightforward and you can directly change anything you need, including all functions, networks, hyperparameters, etc.

#### Usage
```bash
python train_regression.py
```

### Fashion Product Images classification
#### Dataset Download:
The dataset can be directly downloaded from Kaggle.
```
https://www.kaggle.com/paramaggarwal/fashion-product-images-small  
```  

#### Preprocessing
Please unzip the dataset, and use "fashion-preprocess.py" to filter and padding the origal data to avoid too much computation during training.

Note: the "csv_path" should be changed into your own dataset directory.
```bash
python Support/fashion-preprocess.py
```

The data lists used in our experiments are also attached. Please put them in the same directory as your dataset, e.g., "Your_Dir/fashion-dataset/".
```
list_test_mix_all.txt
list_train_mix_all.txt
```

#### Usage
``` bash
python train_fashion.py
```