import pandas as pd
import os
import numpy as np
from PIL import Image

def make_square(im, min_size=32, fill_color=(0, 0, 0)):
    x, y = im.size
    size = max(min_size, x, y)
    new_im = Image.new('RGB', (size, size), fill_color)
    new_im.paste(im, ((size - x) // 2, (size - y) // 2))
    return new_im

csv_path='Your_dir/fashion-dataset'
img_ori_path=csv_path+'/images'
img_save_path=csv_path+'/save'

csv_data=pd.read_csv(csv_path+'/styles.csv',error_bad_lines=False)
csv_data.drop(['productDisplayName'],axis=1,inplace=True)
csv_data.drop(['usage'],axis=1,inplace=True)
csv_data.drop(['year'],axis=1,inplace=True)
csv_data.drop(['articleType'],axis=1,inplace=True)
csv_data.drop(['subCategory'],axis=1,inplace=True)
csv_data=csv_data[csv_data['gender'].isin(['Men','Women'])]
csv_data=csv_data[csv_data['masterCategory'].isin(['Accessories','Apparel','Footwear'])]
csv_data=csv_data[csv_data['baseColour'].isin(['Black','White','Blue'])]
csv_data=csv_data.reset_index(drop=True)

train_sample=csv_data.sample(frac=1,replace=False,axis=0)
img_names=train_sample['id'].tolist()
img_label_gd=np.array(train_sample['gender'].tolist())
img_label_mc=np.array(train_sample['masterCategory'].tolist())
img_label_bc=np.array(train_sample['baseColour'].tolist())

os.makedirs(img_save_path)
pre_process=True
if pre_process:
    for img_name in img_names:
        picpath=os.path.join(img_ori_path,str(img_name)+'.jpg')
        try:
            img=Image.open(picpath)
            new_img=make_square(img)
            new_img.save(os.path.join(img_save_path,str(img_name)+'.jpg'))
        except:
            continue