model_names = [
    "Llama-2-13b-hf",
    "Orca-2-13b",
    "claude2-alpaca-7B-AWQ",
    "Llama-2-7b-hf",
    "Orca-2-7b",
    "gemma-7b",
    "falcon-7b",
    "falcon-7b-instruct",
    "vicuna-7b-v1.5",
    "mpt-7b",
    "OLMo-7B",
    "pythia-6.9b",
    "gemma-2b",
    "phi-2",
    "phi-1_5",
    "gpt2-xl",
    "gpt2-large",
    "gpt2-medium",
    "gpt2"
]

model_labels = {
    'Llama-2-13b-hf': 'Llama-2 13B',
    'Orca-2-13b': 'Orca 2 13B',
    'claude2-alpaca-7B-AWQ': 'Claude 2 Alpaca 13B',
    'Llama-2-7b-hf': 'Llama-2 7B',
    'Orca-2-7b': 'Orca 2 7B',
    'gemma-7b': 'Gemma 7B',
    'falcon-7b': 'Falcon 7B',
    'falcon-7b-instruct': 'Falcon 7B Instruct',
    'vicuna-7b-v1.5': 'Vicuna 7B',
    'mpt-7b': 'MPT 7B',
    'OLMo-7B': 'OLMo 7B',
    'pythia-6.9b': 'Pythia 6.9B',
    'gemma-2b': 'Gemma 2B',
    'phi-2': 'Phi 2B',
    'phi-1_5': 'Phi 1.5B',
    'gpt2-xl': 'GPT2 1.5B',
    'gpt2-large': 'GPT2 774M',
    'gpt2-medium': 'GPT2 355M',
    'gpt2': 'GPT2 117M'
}


def get_model_path(model_name):
    if model_name in ["Llama-2-7b-hf", "Llama-2-13b-hf"]:
        model_path = "meta-llama/" + model_name
    elif model_name in ["falcon-7b", "falcon-7b-instruct"]:
        model_path = "tiiuae/" + model_name
    elif model_name in ["gemma-7b", "gemma-2b"]:
        model_path = "google/" + model_name
    elif model_name in ["vicuna-7b-v1.5"]:
        model_path = "lmsys/" + model_name
    elif model_name in ["mpt-7b"]:
        model_path = "mosaicml/" + model_name
    elif model_name in ["Orca-2-13b", "Orca-2-7b", "phi-2", "phi-1_5"]:
        model_path = "microsoft/" + model_name
    elif model_name in ["OLMo-7B"]:
        model_path = "allenai/" + model_name
    elif model_name in ["pythia-6.9b"]:
        model_path = "EleutherAI/" + model_name
    elif model_name in ["claude2-alpaca-13B-AWQ"]:
        model_path = "TheBloke/" + model_name
    else:
        model_path = model_name
    return model_path


# for generating the dict
"""
model_names_readable = [
    "Llama-2 13B",
    "Orca 2 13B",
    "Claude 2 Alpaca 13B",
    "Llama-2 7B",
    "Orca 2 7B",
    "Gemma 7B",
    "Falcon 7B",
    "Falcon 7B Instruct",
    "Vicuna 7B",
    "MPT 7B",
    "OLMo 7B",
    "Pythia 6.9B",
    "Gemma 2B",
    "Phi 2B",
    "Phi 1.5B",
    "GPT2 1.5B",
    "GPT2 774M",
    "GPT2 355M",
    "GPT2 117M"
]

model_labels = dict(zip(model_names, model_names_readable))
"""
