import openai
import time
from tqdm import tqdm
import numpy as np
import tiktoken
api_key = 'GPT_API_KEY'
api_base = 'https://api.openai.com/v1'
def count_tokens(text):
    encoding = tiktoken.get_encoding("cl100k_base")
    tokens = encoding.encode(text)
    return len(tokens)
def query_gpt_txt(text_list,system_txt=None, temperature=0, max_try_num=10, model="gpt-3.5-turbo-0613"):
    
    result_list = []
    message_list = []
    if system_txt is not None:
        message_list.append({"role":"system", "content":system_txt})
    max_tokens -= count_tokens(system_txt)

    for prompt in tqdm(text_list):
        curr_try_num = 0
        message_list.append({"role":"user", "content":prompt})
        max_tokens -= count_tokens(prompt)
        max_tokens = min(max_tokens,1500)
        print(f"max_tokens: {max_tokens}")
        while curr_try_num < max_try_num:
            try:
                client = openai.OpenAI(api_key=api_key, base_url=api_base)
                completion =client.chat.completions.create(
                    model=model,
                    messages=message_list,
                    temperature = temperature,
                    max_tokens = max_tokens,
                    top_p = 1,
                )
                result = completion.choices[0].message.content
                message_list.append({"role":"assistant", "content":result})
                result_list.append(result)
                break
            except Exception as e:
                print(e)
                curr_try_num += 1
                if curr_try_num >= max_try_num:
                    result_list.append(-1)
                time.sleep(10)
    return result_list