
input_root_path = "mpe_2a2g_1221_wall_noise_2"
output_root_path = "mpe_2a2g_1221_wall_noise_new"
agent_id = 1
file_actions = f"mpe_simple_spread_best_actions{agent_id}.csv"
file_states = f"mpe_simple_spread_best_states{agent_id}.csv"
file_states_after = f"mpe_simple_spread_best_states_after{agent_id}.csv"

# Open input and output files
i = 0
with open(f"{input_root_path}/{file_actions}", "r") as file_action_in, \
     open(f"{input_root_path}/{file_states}", "r") as file_state_in, \
     open(f"{input_root_path}/{file_states_after}", "r") as file_state_after_in, \
     open(f"{output_root_path}/{file_actions}", "w") as file_action_out, \
     open(f"{output_root_path}/{file_states}", "w") as file_state_out, \
     open(f"{output_root_path}/{file_states_after}", "w") as file_state_after_out:

    # Read lines from both input files simultaneously
    for line_a, line_b, line_c in zip(file_action_in, file_state_in, file_state_after_in):
        # Check if the current line of file a starts with "0.0 0.0"
        if not line_c.startswith("0.0 0.0"):
            file_action_out.write(line_a)
            file_state_out.write(line_b)
            file_state_after_out.write(line_c)
        else:
            print(f"Skipping line {i}")
        i += 1
