import abc 
from six import with_metaclass


class MCConvFactory(with_metaclass(abc.ABCMeta)):
    """Abstract class which defines the interface of a convolution factory.
    """


    @abc.abstractmethod
    def get_kernel_type(self):
        """Function to obtain the name of the convolution factory.

        Returns:
            string: Name of the convolution factory.
        """
        pass


    @abc.abstractmethod
    def create_convolution(self, 
        pConvName,
        pNeighborhood, 
        pFeatures,
        pNumOutFeatures,
        pPtGradients,
        pWeightSpectralNorm,
        pWeightRegCollection,
        **kwargs):
        """Function to create a spatial convolution.

        Args:
            pConvName (string): String with the name of the convolution.
            pNeighborhood (MCNeighborhood): Input neighborhood.
            pFeatures (float tensor nxf): Input point cloud features.
            pNumOutFeatures (int): Number of output features.
            pPtGradients (bool): Boolean that indicates if the gradients for the
                point coordinates are computed.
            pWeightSpectralNorm (bool): Boolean that indicates if the weights will be 
                normalized used spectral norm.
            pWeightRegCollection (string): Weight regularization collection name.
            kwargs (list of parameters): Parameters to pass to each specific kernel.

        Returns:
            n'pNumOutFeatures tensor: Tensor with the result of the convolution.
        """
        pass