
#ifndef BUILD_GRID_DS_CUH_
#define BUILD_GRID_DS_CUH_

#include "defines.hpp"
#include "gpu_device.hpp"
#include <memory>

namespace mccnn{
        
    /**
     *  Method to compute the data structure to access a sparse regular grid.
     *  @param  pDevice                 Device.
     *  @param  pDSSize                 Size of the data structure.
     *  @param  pNumPts                 Number of points.
     *  @param  pInGPUPtrKeys           Input pointer to the vector of keys 
     *      on the GPU.
     *  @param  pInGPUPtrNumCells       Input pointer to the vector of number  
     *      of cells on the GPU.
     *  @param  pInGPUpOutGPUPtrKeys    Output pointer to the data structure  
     *      on the GPU.
     *  @paramT D                       Number of dimensions.
     */
    template<int D>
    void build_grid_ds_gpu(
        std::unique_ptr<IGPUDevice>& pDevice,
        const unsigned int pDSSize, 
        const unsigned int pNumPts,
        const mccnn::int64_m* pInGPUPtrKeys,
        const int* pInGPUPtrNumCells,
        int* pOutGPUPtrDS);
}

#endif