
#ifndef STORE_UNIQUE_KEYS_CUH_
#define STORE_UNIQUE_KEYS_CUH_

#include "defines.hpp"
#include "gpu_device.hpp"
#include <memory>

namespace mccnn{
        
    /**
     *  Method to store the first point index for each unique keys on the gpu.
     *  @param  pDevice                 Device.
     *  @param  pNumPts                 Number of points.
     *  @param  pInKeysGPUPtr           Input pointer to the vector of keys  
     *      sorted from bigger to smaller residing on GPU memory.
     *  @param  pFIndexKeys             Output pointer to the array with 
     *      the first point index for each unique key.
     */
    void store_unique_keys_gpu(
        std::unique_ptr<IGPUDevice>& pDevice,
        const unsigned int pNumPts,
        const mccnn::int64_m* pInKeysGPUPtr,
        int* pFIndexKeys);
}

#endif