import argparse

# omniglot
def args_parser():
    parser = argparse.ArgumentParser('MAML')

    # General
    parser.add_argument('--folder', type=str, default='./data',
        help='Path to the folder the data is downloaded to.')
    parser.add_argument('--algorithm',type=str, default='DynamicMetaProx',help='Choice of algorithm:MAML,MetaProx')
    parser.add_argument('--dataset', type=str,
        choices=['sinusoid', 'omniglot', 'miniimagenet'], default='sinusoid',
        help='Name of the dataset (default: omniglot).')
    parser.add_argument('--num-tasks',type=int, default=100,help='Number of training tasks')
    parser.add_argument('--test-num-tasks',type=int, default=10000,help='Number of training tasks')
    parser.add_argument('--num-ways', type=int, default=5,
        help='Number of classes per task (N in "N-way", default: 5).')
    parser.add_argument('--num-shots', type=int, default=5,    
        help='Number of training example per class (k in "k-shot", default: 1).')
    parser.add_argument('--num-shots-test', type=int, default=5,   
        help='Number of test example per class. If negative, same as the number ')    

    # Model
    parser.add_argument('--hidden-size', type=int, default=64,
        help='Number of channels in each convolution layer of the VGG network '
        '(default: 64).')
    
    #   
    parser.add_argument('--batch-size', type=int, default=25,   
        help='Number of tasks in a batch of tasks (default: 25).')
    parser.add_argument('--num-steps', type=int, default=2,     
        help='Number of fast adaptation steps, ie. gradient descent '
        'updates (default: 1).')        
    parser.add_argument('--num-epochs', type=int, default=200,  
        help='Number of epochs of meta-training (default: 500).')  
    parser.add_argument('--step-size', type=float, default=0.02,     
        help='Size of the fast adaptation step, ie. learning rate in the ')   
    parser.add_argument('--first-order', default=False,     
        help='Use the first order approximation, do not use higher-order '
        'derivatives during meta-optimization.')      
    parser.add_argument('--meta-lr', type=float, default=0.09,      
        help='Learning rate for the meta-optimizer (optimization of the outer '
        'loss).')           
    parser.add_argument("--lamda", type=float, default=1, help="Regularization term") 

    parser.add_argument("--beta", type=float, default=2, help="A dynamic weight factor") 
    parser.add_argument("--dyfac", type=float, default=3, help="A dynamic weight factor") 
    parser.add_argument('--cg_steps', type=int, default=5) 

    # Misc
    parser.add_argument("--gpu", type=int, default=0
                        , help="Which GPU to run the experiments, -1 mean CPU, 0,1,2 for GPU")
    parser.add_argument('--num-workers', type=int, default=32,
        help='Number of workers to use for data-loading (default: 4).')
    
    args = parser.parse_args()
    return args