@kwdef mutable struct Test <: IPOMDP{Int, Int, Int} 
    discount::Float64       = 0.9999
    p_interval::Interval    = interval(0.8,0.99)
end

max_interval = interval(0.0001, 0.9999)

POMDPs.states(M::Test) = 0:5
POMDPs.statetype(M::Test) = Int
POMDPs.stateindex(M::Test, s::Int) = s+1
POMDPs.actions(M::Test) = [1,2]
POMDPs.actiontype(M::Test) = Int
POMDPs.actionindex(M::Test, a::Int) = a
POMDPs.observations(M::Test) = [1]
POMDPs.obstype(M::Test) = Int
POMDPs.obsindex(M::Test, o::Int) = o
POMDPs.discount(M::Test) = M.discount
POMDPs.initialstate(M::Test) = SparseCat([0], [1.0])
POMDPs.isterminal(M::Test, s::Int) = s==5

function POMDPs.transition(M::Test, s,a)
    s==0 && a==3 && return SparseICat([1,2], [interval(0.5), interval(0.5)])
    s==0 && return SparseICat([a], [interval(1.0)])
    s==1 && return SparseICat([3,4], [M.p_interval, max_interval])
    s==2 && return SparseICat([3,4], [max_interval, M.p_interval,])
    s>2 && return SparseICat([5], [interval(1.0)])
    println("help! $s, $a")
end

POMDPs.observation(M::Test, a, sp) = SparseCat([1], [1.0])

POMDPs.reward(M::Test, s, a, sp) = reward(M,s,a)
function POMDPs.reward(M::Test, s, a)
    s==3 && a==1 && return 100.0
    s==4 && a==2 && return 100.0
    return 0.0
end