# Evaluation in RPOMDPs
Codebase for the NeurIPS 2025 paper entitled "On Evaluating Policies for Robust POMDPs". We provide a readme for reproducing the experiments.

## Reproducing experiments

Install Julia. The experiments in the paper used version 1.11.5. To run the code, a Gurobi license is required (there exists a free academic license).

Then, in a shell, executer `julia` followed by `]` and enter `activate .` followed by `instantiate`. Julia's Pkg will collect the dependencies.

Lastly, install the helper scripts in `GNU Parallel` to run multiple processes. E.g.:

```
sudo apt-get install parallel
```

After this is all done, run:

```
chmod +x RunAll.sh
GRB_LICENSE_FILE="/YOUR/PATH/TO/gurobi.lic" ./RunAll.sh
```

## Results

Results will collect in `./Data/Tests/`. 

Reproduce plots by executing the Jupyter notebook `DataCollection.ipynb` in this directory.

In the current set-up, running all experiments takes approximately up to 10 hours (10 benchmarks * 6 solvers * timeout of 1800 seconds / 3 workers).
