module RPOMDPs
    using POMDPs, POMDPTools, QuickPOMDPs, Random, IntervalArithmetic, Distributions, JuMP, Clp, HiGHS, Gurobi, SparseArrays, D3Trees, Memoize, LRUCache

    # Surpressing Gurobis printing
    oldstd = stdout
    redirect_stdout(devnull)
    const GRB_ENV=Gurobi.Env()
    redirect_stdout(oldstd)

    include("rpomdps.jl")
    export RPOMDP, IPOMDP
    include("approximate.jl")
    export to_mid_POMDP, to_rmdp_POMDP, to_maxent_POMDP

    # Solvers
    include("Algorithms/Beliefs.jl") #TODO: copied, remove irrelevant code!
    include("Algorithms/Caching.jl") #TODO: copied, remove irrelevant code!
    include("Algorithms/RobustAlphaVectors.jl")
    export AlphaVector, AlphaVectorPolicy
    include("Algorithms/RQMDP.jl")
    export RQMDPSolver, RQMDPPlanner, RFIBSolver, RFIBPlanner
    include("Algorithms/RPBVI.jl")
    export RPBVISolver, backup
    include("Algorithms/RHSVI.jl")
    export RHSVISolver

    #...
    include("adversarialnature.jl")
    export get_model_adversary, An, Sn

    #...
    include("makeuncertain.jl")
    export RobustifiedPOMDP, ConfidencePOMDP,
    IntervalType, AdditiveAbs, AdditiveRel, Multiplicative 

    # Envs (I don't know if we want those here...)
    include("../Envs/Toy.jl")
    export Toy, Toy_mid, Toy_rmdp
    include("../Envs/Chain.jl")
    export ChainInf, ChainN
    include("../Envs/Machine.jl")
    export Machine
    include("../Envs/POMDPs/HeavenOrHell.jl")
    export HeavenOrHell
    include("../Envs/POMDPs/Aloha.jl")
    export Sparse_aloha10
    include("../Envs/POMDPs/K-out-of-N.jl")
    export K_out_of_N
    include("../Envs/CNC_Detection.jl")
    export CNC_Detection
    include("../Envs/POMDPs/Replacement.jl") 
    export MachineReplacement
    include("../Envs/Test.jl")
    export Test
end

