function plot_result(n, p, k)

file_name = ['result_n' num2str(n) '_p' num2str(p) '_k' num2str(k) '.mat'];
load(file_name);

figure;
plot(snr_arr, corr_rate_mat(1, :), 'r-x', 'linewidth', 2, 'MarkerSize', 6); hold on; grid on;
plot(snr_arr, corr_rate_mat(2, :), 'k-^', 'linewidth', 2, 'MarkerSize', 6);
plot(snr_arr, corr_rate_mat(3, :), 'b-o', 'linewidth', 2, 'MarkerSize', 6);

set(gca,'FontSize',20);

lgn = {};
for mIdx = 1:length(simul_param.m_arr)
    lgn{mIdx} = ['$\textup{srank}(\mathbf{B}^{\natural}) = $', num2str(simul_param.m_arr(mIdx))];
end

legend(strvcat(lgn{:}), 'Interpreter' , 'latex', 'FontSize', 20, 'Position', [0.58, 0.3, 0.2, 0.2]);

text(0.55, 0.93, ['Gaussian'],'fontsize', 20, 'fontweight', 'bold', 'color', 'r');
text(1.05, 0.05, ['n = ' num2str(simul_param.n), ', p = ', num2str(simul_param.p), ', k = ' num2str(simul_param.k)],...
    'fontsize', 18, 'fontweight', 'bold', 'color', 'r');	
xlabel('SNR');
ylabel('Recovery Prob.');