function [ret_B] = signal_generator_refine(n, p, m, k, sigma_n, snr_param)

ret_B = zeros(p, m);

if m < k
    sub_mat = rand(k, k); 
    [u1, s1, v1] = svd(sub_mat); 
    
    ret_B = zeros(p, m); 
    ret_B(1:k, :) = u1(:, 1:m); 
    
else 
    sub_mat = rand(k, k); 
    [u1, s1, v1] = svd(sub_mat); 
    B_mat = u1; 
                                     
    sub_mat_num = floor(min(p, m)/k); 

    for idx = 1:1:sub_mat_num - 1
        sub_mat = rand(k, k); 
        [u1, s1, v1] = svd(sub_mat); 

        B_mat = blkdiag(B_mat, u1); 
    end

        if mod(min(p, m), k) ~= 0  
    
        k2 = rem(min(p, m), k); 
        zero_mat = zeros(sub_mat_num * k, k2); 
   
        sub_mat2 = rand(k2, k2); 
        [u2, s2, v2] = svd(sub_mat2);
        sub_mat2 = u2; 
   
        B_mat = blkdiag(B_mat, sub_mat2); 
    end

    if p <= m 
        ret_B(:, 1:p) = B_mat;
    else
        ret_B(1:m, :) = B_mat; 
    end


end 

ret_B = sqrt(snr_param * m * sigma_n) * ret_B/norm(ret_B, 'fro');

ret_B(:, 1:m) = ret_B(:, randperm(m)); 


end 





