function [simul_statis] =  unit_case_simulator(simul_param, m, snr_param)

pi_natural = permute_generator(simul_param.n, ceil(simul_param.n/4));

for idx = 1: 1: simul_param.max_case

    X = normrnd(0, 1, [simul_param.n, simul_param.p]);
    B = signal_generator_refine(simul_param.n, ...
        simul_param.p, ...
        m, ...
        simul_param.k, ...
        simul_param.sigma_n, ...
        snr_param);
    N = simul_param.sigma_n * normrnd(0, 1, [simul_param.n, m]);

    Y = X * B + N;
    Y = Y(pi_natural, :);
    pi_hat = onestepsolver(X, Y);
    simul_statis.diff_pi_arr(idx) = norm(pi_natural - pi_hat, 'fro');
end

simul_statis.ylab = sum(simul_statis.diff_pi_arr == 0)/simul_param.max_case;
