

# What is in this repository.
In this file, we provide:
1. Data used for slice discovery in the classification task in ./data/classification. 
2. Visualization method for exploring the slices identified by DebugAgent
3. Intermediate outputs of DebugAgent of all the three tasks
4. Code for attribute and tag generations, slice enumeration, predict unseen slices

# Visualize the slices identified by DebugAgent
We provide slice visualzation. It requires gradio.
`python slice_visualization.py`

# Check attributes and tags used for the three task
We provide the original output file for the three tasks. For example, the attributes and tags in classification task is `outputs/classification/bear_tags_refined.json`. The tag annotations for all images is in  `outputs/classification/bear_labels.pkl`. 

# Run attributes and tags generation
This require an api key for chatgpt. Fill your api key in `api_key.py`. The speed of this step is depends on internet. For tag assignment, you can set a large number of worker to parallel the process. 

# Run slice enumeration and baseline
You can run `python slice_enumeration.py` for slice enumeration. Change the function name to test baseline methods.

# Run unseen slice generation
We provide the outputs in `outputs/bear_predict_slices_sub.json` and `outputs/bear_predict_slices_gpt.json`. You can also run `python slice_predict.py` for unseen slice prediction. 

# Dirtories:
- assets: few shot examples for prompts
- analyse: enumeration alogrithm and unseen prediction alogrithm
- outputs: attributes, tags, annotations, model predictions... files. We have removed all senstive paths.
- preprocess: code for attribute and tag generation
- prompts: prompts
- utils: gpt control, and other functions