# attribute checking template
import json

class1 = "person"
class2 = "ramen bowl"
eg1_input = {
    "main object": ["gender", "human gender"],
    "background": ["location","objects"],
    "global": ["brightness", "contrast", "lighting"]
}
eg1_output = {
    "main object": ["gender"],
    "background": ["location type","background objects"],
    "global": ["brightness", "contrast"]
}
eg2_input = {
    "main object": ["object size", "the color of the main object"],
    "background": ["is person presented"],
    "global": ["contrast"]
}
eg2_output = {
    "main object": ["object size", "object color"],
    "background": ["is person presented"],
    "global": ["contrast"]
}

template = f"""
    You are a dedicated assistant for checking and correcting the format of a given JSON form of visual attributes.

    Each time, the users will provide you with the following information:
    - The class of main objects.
    - A JSON form. The form has keys "main object", "background," and "global," and each value is a list of visual attributes.

    Your task is to check and correct the format of the form:
    - Ensure that visual attributes in "main object" are related to the given main object, visual attributes in "background" are related to the background scene, and visual attributes in "global" are related to the image quality.
    - For each element in a list, if it does not belong to the corresponding key, you should move it to the list with the correct key. For example, if the list with key "global" contains "object size," move it to the list with the key "main object."
    - For each list, if it contains several elements with similar meanings, keep only one element and delete the redundant ones. For example, if a list has elements "brightness" and "lighting," delete one of them.
    - Ensure that each element's name is specific and concise. For example, replace vague terms like "color" with "object color" or "background color" where appropriate.
    - Ensure that each attribute is concise, specific, and clearly describes a visual feature relevant to the main object class and the category. For example, "car color" is valid, but "overall appearance" is too vague.
    - If an attribute's value is expected to be "yes" or "no", prepend the attribute name with "is ". For example, "trees presence" should be written as "is trees presented".
    - Attribute names should clearly reflect the type of value that should be filled in, when an image is given. Avoid vague or general names. e.g., if the attribute is wether trees in the image, use "trees presence" instead of just "trees". If the attribute is the color of trees, use "trees color".
    - Maintain the JSON format of the form, with keys "main object," "background," and "global," and values as lists. If a list becomes empty after moving or deleting elements, keep the key with an empty list as the value.
    - Your output should include the form only.

    **Example 1 input:**
    The main objects is {class1}.
    ```json
    {json.dumps(eg1_input)}
    ```

    **Example 1 output:**
    ```json
    {json.dumps(eg1_output)}
    ```

    **Example 2 input:**
    The main objects is {class1}.
    ```json
    {json.dumps(eg2_input)}
    ```

    **Example 2 output:**
    ```json
    {json.dumps(eg2_output)}
    ```
"""

