# attribute extraction template
import json

eg_images = {
"img11_path" : "./assets/tench1.png",
"img12_path" : "./assets/tench2.png",
"img21_path" : "./assets/dumbbell1.png",
"img22_path" : "./assets/dumbbell2.png",
}

class1 = "tench"
class2 = "dumbbell"
eg1_input = {
    "main object": ["object size"],
    "background": [],
    "global": []
}
eg1_output = {
    "main object": ["object size"],
    "background": ["background complexity",],
    "global": ["brightness"]
}
eg2_input = {
    "main object": ["object size", "object color"],
    "background": ["background location",],
    "global": []
}
eg2_output = {
    "main object": ["object size", "object color"],
    "background": ["background location","is human presented"],
    "global": []
}

template = """
    You are a dedicated assistant for spotting the differences between two images and summarizing them into common visual attributes.

    1. Inputs Provided:
    - Two images featuring the same main object class.
    - The class of main objects.
    - A JSON form with keys: "main object", "background", and "global". Each key contains a list of visual attributes.

    2. Task:
    - Analyze the visual differences between the two images and propose new visual attributes that highlight these differences.
    - Add these new attributes to the corresponding list in the JSON form:
        1."main object": Attributes related to the main object itself (e.g., "object color", "object size", "object clothes").
        2."background": Attributes related to the background scene (e.g., "background color", "is sky presented","natural habitat").
        3."global": Attributes related to the overall image quality (e.g., "brightness", "contrast").
    - When you refer the main object class name in attributes, such as "teddy bear color", write it as "object color". 
    - Ensure that each attribute is concise, specific, and clearly describes a visual feature relevant to the main object class and the category. For example, "object color" is valid, but "overall appearance" is too vague.
    - Avoid generating attributes that overlap significantly with each other. Each attribute should describe a distinct feature.
    - If an attribute's value is expected to be "yes" or "no", prepend the attribute name with "is ". For example, "trees presence" should be written as "is trees presented".
    - Attribute names should clearly reflect the type of value that should be filled in, when an image is given. Avoid vague or general names. e.g., if the difference is wether trees in the image, use "is trees presented" instead of just "trees". If the difference is the color of trees, use "trees color".
    - Visual attributes should be concise, specific, and clearly describe a visual feature. For example, "object background" and "overall appearance" is too vague.
    - Only propose attributes that clearly differentiate the two images. Avoid generating redundant or insignificant attributes.

    3. Output:
    - Provide the updated JSON object with keys "main object", "background", and "global", each containing a list of visual attributes. Ensure the attributes are unique and relevant.
    - Your output should include the form only.

    Now I will give you some examples.
    """

example = f"""
    Example:

    **Example 1 input:**
    Image 1: the first image
    Image 2: the second image
    The main objects is {class1}
    Form:
    ```json
    {json.dumps(eg1_input)}
    ```

    **Example 1 output:**
    ```json
    {json.dumps(eg1_output)}
    ```

    **Example 2 input:**
    Image 1: the third image
    Image 2: the fourth image
    The main objects is {class2}
    Form:
    ```json
    {json.dumps(eg2_input)}
    ```

    **Example 2 output:**
    ```json
    {json.dumps(eg2_output)}
    ```
"""

