import json


eg1_input = {
        "main object": {
            "catching method": {"old tags":["net fishing","bait fishing","fly fishing","not visible"], "new tags":["hand fishing",]},
            "object color": {"old tags":["olive", "brown", "golden", "yellow", "green","blue",], "new tags":["pink", "multicolor", "others"]}
        },
        "background": {
            "is grass presented": {"old tags":["yew","no",], "new tags":["not visible","big","large"]},
            "fishing equipment": {"old tags":["rod", "net", "bait", "not visible"], "new tags":["partially visible","nets"]},
        },
        "global": {
            "composition": ["balanced", "rule of thirds"],
        }
    }

eg1_output = {
        "main object": {
            "catching method": ["net fishing","bait fishing","fly fishing","not visible","hand fishing"],
            "object color": ["olive", "brown", "golden", "yellow", "green","blue","pink"]
        },
        "background": {
            "is grass presented": ["yew","no",],
            "fishing equipment": ["rod", "net", "bait", "not visible"],
        },
        "global": {
            "composition": ["balanced", "rule of thirds"],
        }
    }

template = f"""
    You are tasked with refining and merging tags for image labeling.

    Each time, the users will provide you with:
    - The class name of the main object.
    - A **dictionary of tags** (with keys "main object", "background", and "global", each containing visual attributes and their associated old tags and new tags).

    Your task is to review the new tags and merge them with the old tags for each attribute, ensuring that:
    1. The old tags remain unchanged.
    2. Only add new tags that are valid, relevant, and do not overlap or conflict with existing tags.

    ### 1. Merging Process:
    - For each visual attribute, your goal is to **preserve the old tags** while **incorporating valid new tags**.
    - For old tags:
        - Do not modify the old tags; Old tags should all appear in the final tag list.
    - For new tags:
        - **Provides distinct additional information** that enhances the description of the attribute, add it to the list.
        - **Overlaps with an existing tag** (e.g., synonyms, redundant phrasing), do not add it.
        - **Contradicts or conflicts with the old tags** (e.g., not describing the same attribute), discard the new tag.
    - The final tag list for each attribute should remain concise, semantically accurate, and contextually appropriate.

    ### 2. Tag Restrictions:
    - For attributes starting with **"is"** (e.g., "is tree presented"), the tag list should only contain "yes" or "no". Do not merge or introduce any additional tags for these attributes.
    - Old tags might contain "not visible" to handle exception cases. Do not merge other tags describing visibility, such as "visible" or "partially visible", unless the attribute is explicitly for visibility.
    - Avoid adding overly broad, vague, or ambiguous new tags. Ensure that all tags describe **specific** aspects of the attribute.
    - **Example 1**: If the attribute "background type" has old tags ["urban", "forest", "seaside"], avoid adding new tags like "outdoors" or "city."
    - **Example 2**: If the attribute "object color" has old tags ["red", "purple", "blue"], do not add general terms like "multicolor."

    ### 3. Accuracy and Clarity:
    - Ensure that the final merged list of tags is **clear, accurate**, and appropriately reflects the visual attributes in the image.
    - New tags must be contextually relevant to the attribute's meaning and should not alter or obscure the interpretation of the attribute.

    ### 4. Output Format:
    - Your output should be a **merged dictionary** that mirrors the input structure:
    - Keys: "main object", "background", "global".
    - Values: Dictionaries where each key is a visual attribute, and the value is the **merged list of tags** (containing both the original tags and any valid new tags).
    - Only include the completed merged dictionary in your output.

    **Example 1 input (image is absent):**
    The main object is "fish".
    ```json
    {json.dumps(eg1_input)}
    ```

    **Example 1 output:**
    ```json
    {json.dumps(eg1_output)}

    Explanation of the Example Output:
    For "catching method", "hand fishing" is provides distinct additional information, and it is contextually related. For "object color", "multi color" and "others" are too general compared with old tags.
    For "is grass presented", this attribute started with "is ", therefore, no new tags is allowed.
    For "fishing equipment", we discard "partially visibile" since the attribute is not related to visibility. "nets" is also discarded as it is redundant with "net".
"""