import json


template = f"""
    You are a dedicated assistant for predicting the combinations of attribute-tag pairs that can possibly result in failure of existing image classification neural network models.

    Each time, the users will provide you with the following information:
    - The main object of the images. 
    - A json form that records all attributes and tags involved. For each object class, the attributes and tags can be categorized as `main object`, `background` and `global`. Each attribute corresponds to multiple tags. All attributes and tags of all categories and object classes compose the json form. - Visual attributes in "main object" are related to the given main object. Visual attributes in "background" are related to the background scene. Visual attributes in "global" are related to the image quality.
    - A positive integer.

    Your task is to predict as many combinations of attribute-tag pairs as possible. The combinations are supposed to be highly possible to make existing image classification neural network models fail.
    - Your output is a form. The form is a dictionary, with "predictions" as key and a list of dictionaries as value. In each dictionary in the list, the key is attribute category and value is a dictionary with attributes as keys and tags as values. 
    - You need to predict as many combinations as possible.
    - You need to use the given attributes and tags, and not create new ones.
    - For each predicted attribute, you need to assign one and only one tag.
    - In each combination, the total number of attribute-tag pairs must be equal to the given integer.
    - In the predicted combinations, there can be multiple attributes of the same category.
    - You need to ensure that the predicted combinations are highly possible to make existing models fail. For example, the predicted combinations might make the main object indistinguishable from the background.
    - You output the form only. No explanation in your output.

    **Example 1 input:**
    The main object is "brid".
    The number of attribute-tag pairs in each predicted combination is 3
    ```json
    {json.dumps({
        "bird": {
            "main object": {
                "color": ["green", "blue", "black"],
                "size":["big","medium","small"],
                "number":["one","two","many"]
            },
            "background": {
                "background object": ["ocean", "sky", "tree"],
            },
            "global": {
                "contrast": ["high", "medium", "low"],
                "light":["high", "medium", "low"]
            },
        },
    })}
    ```

    **Example 1 output:**
    ```json
    {json.dumps({
        "predictions": [
            {
                "main object": {"color": "blue"},
                "background": {"background object": "ocean"},
                "global": {"contrast": "low"},
            },
            {
                "main object": {"color": "blue"},
                "background": {"background object": "sky"},
                "global": {"light": "high"},
            },
            {
                "main object": {"color": "green","size":"small"},
                "background": {"background object": "sky"},
                "global": {},
            },
            {
                "main object": {"color": "black","size":"small"},
                "background": {},
                "global": {"light": "low"},
            },
        ],
    })}
    ```

    For the first combination: Birds are usually in the sky. Images of birds with ocean background may make existing models fail.
    For the second combination: The sky and the brid are both blue. Given high light condition, blue birds with such backgrounds may make the main object indistinguishable from the background and make existing models fail.
    For the third combination: Similarly, green brid in a tree is often indistinguishable.
    For the 4th combination: Low light may also make the black and small brid indistinguishable from the background and make existing models fail.

"""
